/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.property.impl;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.foxgenesis.property.ImmutableProperty;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.PropertyType;
import net.foxgenesis.property.lck.LCKPropertyResolver;
import net.foxgenesis.watame.plugin.Plugin;
import net.foxgenesis.watame.property.PluginProperty;
import net.foxgenesis.watame.property.PluginPropertyProvider;
import net.foxgenesis.watame.property.impl.CachedPluginProperty;
import org.jetbrains.annotations.NotNull;

public class PluginPropertyProviderImpl
implements PluginPropertyProvider {
    private final CopyOnWriteArrayList<PluginProperty> map = new CopyOnWriteArrayList();
    private final LCKPropertyResolver database;
    private final long cacheTime;

    public PluginPropertyProviderImpl(@NotNull LCKPropertyResolver database, long cacheTime) {
        this.database = Objects.requireNonNull(database);
        this.cacheTime = cacheTime;
    }

    @Override
    public PropertyInfo registerProperty(Plugin plugin, String key, boolean modifiable, PropertyType type) {
        if (!this.propertyExists(plugin, key)) {
            return this.database.createPropertyInfo(plugin.name, key, modifiable, type);
        }
        return this.database.getPropertyInfo(plugin.name, key);
    }

    @Override
    public PluginProperty upsertProperty(Plugin plugin, String key, boolean modifiable, PropertyType type) {
        return this.getProperty(this.registerProperty(plugin, key, modifiable, type));
    }

    @Override
    public PluginProperty getProperty(Plugin plugin, String key) {
        PluginProperty cached = this.inCache(plugin, key);
        if (cached != null) {
            return cached;
        }
        return this.getProperty(this.database.getPropertyInfo(plugin.name, key));
    }

    @Override
    public PluginProperty getProperty(PropertyInfo info) {
        PluginProperty cached = this.inCache(info);
        if (cached != null) {
            return cached;
        }
        cached = new CachedPluginProperty(info, this.database, this.cacheTime);
        this.map.addIfAbsent(cached);
        return cached;
    }

    @Override
    public boolean propertyExists(Plugin plugin, String key) {
        if (this.inCache(plugin, key) != null) {
            return true;
        }
        return this.database.isRegistered(plugin.name, key);
    }

    @Override
    public List<PropertyInfo> getPropertyList() {
        return this.map.stream().map(ImmutableProperty::getInfo).toList();
    }

    @Override
    public PluginProperty getPropertyByID(int id) {
        PluginProperty info = this.inCache(id);
        if (info != null) {
            return info;
        }
        return this.getProperty(this.database.getPropertyByID(id));
    }

    private PluginProperty inCache(Plugin plugin, String key) {
        for (PluginProperty pair : this.map) {
            if (!pair.getInfo().category().equalsIgnoreCase(plugin.name) || !pair.getInfo().name().equalsIgnoreCase(key)) continue;
            return pair;
        }
        return null;
    }

    private PluginProperty inCache(PropertyInfo info) {
        for (PluginProperty pair : this.map) {
            if (!pair.getInfo().equals(info)) continue;
            return pair;
        }
        return null;
    }

    private PluginProperty inCache(int id) {
        for (PluginProperty pair : this.map) {
            if (pair.getInfo().id() != id) continue;
            return pair;
        }
        return null;
    }
}

