/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.property.impl;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import net.dv8tion.jda.api.entities.Guild;
import net.foxgenesis.property.PropertyException;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.lck.LCKPropertyResolver;
import net.foxgenesis.watame.property.PluginProperty;
import net.foxgenesis.watame.property.PluginPropertyMapping;
import org.jetbrains.annotations.NotNull;

public class PluginPropertyImpl
implements PluginProperty {
    private final PropertyInfo info;
    protected final LCKPropertyResolver resolver;

    public PluginPropertyImpl(@NotNull PropertyInfo info, @NotNull LCKPropertyResolver resolver) {
        this.info = Objects.requireNonNull(info);
        this.resolver = Objects.requireNonNull(resolver);
    }

    @Override
    public Optional<PluginPropertyMapping> get(Guild lookup) {
        return this.resolver.getInternal(lookup.getIdLong(), this.getInfo()).map(t -> {
            try {
                return new PluginPropertyMapping(lookup, (Blob)t, this.getInfo().type());
            }
            catch (IOException | SQLException e) {
                throw new PropertyException(e);
            }
        });
    }

    @Override
    public boolean set(Guild lookup, InputStream in, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        return this.resolver.putInternal(lookup.getIdLong(), this.getInfo(), in);
    }

    @Override
    public boolean remove(Guild lookup, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        return this.resolver.removeInternal(lookup.getIdLong(), this.getInfo());
    }

    @Override
    public boolean isPresent(Guild lookup) {
        return this.resolver.isPresent(lookup.getIdLong(), this.getInfo());
    }

    @Override
    public PropertyInfo getInfo() {
        return this.info;
    }

    public int hashCode() {
        return Objects.hash(this.info, this.resolver);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PluginPropertyImpl other = (PluginPropertyImpl)obj;
        return Objects.equals(this.info, other.info) && Objects.equals(this.resolver, other.resolver);
    }

    public String toString() {
        return "PluginPropertyImpl [" + (String)(this.info != null ? "info=" + this.info + ", " : "") + (String)(this.resolver != null ? "resolver=" + this.resolver : "") + "]";
    }
}

