/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.property.impl;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.dv8tion.jda.api.entities.Guild;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.PropertyType;
import net.foxgenesis.property.lck.LCKPropertyResolver;
import net.foxgenesis.property.lck.impl.CachedObject;
import net.foxgenesis.watame.property.PluginPropertyMapping;
import net.foxgenesis.watame.property.impl.PluginPropertyImpl;

public class CachedPluginProperty
extends PluginPropertyImpl {
    protected final ConcurrentHashMap<Long, CachedObject<PluginPropertyMapping>> cache = new ConcurrentHashMap();
    private final long cacheTime;

    public CachedPluginProperty(PropertyInfo info, LCKPropertyResolver resolver, long cacheTime) {
        super(info, resolver);
        this.cacheTime = cacheTime;
    }

    @Override
    public Optional<PluginPropertyMapping> get(Guild lookup) {
        this.init(lookup);
        return Optional.ofNullable(this.cache.get(lookup.getIdLong()).get());
    }

    @Override
    public boolean set(Guild lookup, byte[] data, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        this.init(lookup);
        if (super.set(lookup, data, isUserInput)) {
            this.cache.get(lookup.getIdLong()).set(this.createMapping(lookup, data, this.getInfo().type()));
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Guild lookup, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        if (super.remove(lookup, isUserInput)) {
            this.cache.get(lookup.getIdLong()).set(null);
            return true;
        }
        return false;
    }

    protected void init(Guild lookup) {
        if (!this.cache.containsKey(lookup.getIdLong())) {
            this.cache.put(lookup.getIdLong(), new CachedObject<PluginPropertyMapping>(() -> super.get(lookup).orElse(null), this.cacheTime));
        }
    }

    protected PluginPropertyMapping createMapping(Guild lookup, byte[] data, PropertyType type) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new PluginPropertyMapping(lookup, data, type);
    }
}

