/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.plugin;

import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;
import net.foxgenesis.util.CompletableFutureUtils;
import net.foxgenesis.util.MethodTimer;
import net.foxgenesis.watame.Context;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.plugin.CommandProvider;
import net.foxgenesis.watame.plugin.Plugin;
import net.foxgenesis.watame.plugin.SeverePluginException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class PluginHandler<@NotNull T extends Plugin>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(PluginHandler.class);
    @NotNull
    private final ConcurrentHashMap<String, T> plugins = new ConcurrentHashMap();
    @NotNull
    private final ServiceLoader<T> loader;
    @NotNull
    private final ModuleLayer layer;
    @NotNull
    private final Class<T> pluginClass;
    @NotNull
    private final ExecutorService pluginExecutor;
    @NotNull
    private final Context context;

    public PluginHandler(Context context, ModuleLayer layer, Class<T> pluginClass) {
        this.context = Objects.requireNonNull(context);
        this.layer = Objects.requireNonNull(layer);
        this.pluginClass = Objects.requireNonNull(pluginClass);
        this.loader = ServiceLoader.load(layer, pluginClass);
        this.pluginExecutor = context.getAsynchronousExecutor();
    }

    public void loadPlugins() {
        logger.info("Checking for plugins...");
        List<ServiceLoader.Provider<ServiceLoader.Provider>> providers = this.loader.stream().toList();
        logger.info("Found {} plugins", (Object)providers.size());
        logger.info("Constructing plugins...");
        long time = System.nanoTime();
        providers.forEach(provider -> {
            logger.debug("Loading {}", provider.type());
            try {
                Plugin plugin = (Plugin)provider.get();
                this.plugins.put(plugin.name, plugin);
                this.context.getEventRegister().register(plugin);
                logger.info("Loaded {}", (Object)plugin.getDisplayInfo());
            }
            catch (ServiceConfigurationError e) {
                logger.error("Failed to load " + provider.type(), (Throwable)e);
            }
        });
        time = System.nanoTime() - time;
        logger.info("Constructed all plugins in {}ms", (Object)MethodTimer.formatToMilli(time));
    }

    public void preInit() {
        this.forEach(Plugin::preInit);
    }

    @NotNull
    public void init() {
        this.forEach(plugin -> plugin.init(this.context.getEventRegister()));
    }

    @NotNull
    public void postInit(WatameBot watamebot) {
        this.forEach(plugin -> plugin.postInit(watamebot));
    }

    @NotNull
    public CompletableFuture<Void> onReady(WatameBot watamebot) {
        return this.forEachPlugin(plugin -> plugin.onReady(watamebot), null);
    }

    @NotNull
    public CommandListUpdateAction updateCommands(CommandListUpdateAction action) {
        this.plugins.values().stream().filter(p -> p instanceof CommandProvider).map(CommandProvider.class::cast).map(CommandProvider::getCommands).filter(Objects::nonNull).forEach(arg_0 -> ((CommandListUpdateAction)action).addCommands(arg_0));
        return action;
    }

    @NotNull
    private CompletableFuture<Void> forEachPlugin(Consumer<? super T> task, @Nullable Predicate<Plugin> filter) {
        if (filter == null) {
            filter = p -> true;
        }
        return CompletableFutureUtils.allOf(this.plugins.values().stream().filter(filter).map(plugin -> CompletableFuture.runAsync(() -> task.accept(plugin), this.pluginExecutor).exceptionallyAsync(error -> {
            this.pluginError((T)plugin, (Throwable)error);
            return null;
        }, (Executor)this.pluginExecutor)));
    }

    private void forEach(Consumer<? super T> task) {
        this.forEach(null, task);
    }

    private void forEach(@Nullable Predicate<T> filter, Consumer<? super T> task) {
        for (Plugin t : this.plugins.values()) {
            if (filter != null && !filter.test(t)) continue;
            try {
                task.accept(t);
            }
            catch (Exception e) {
                this.pluginError(t, e);
            }
        }
    }

    private void unloadPlugin(T plugin) {
        logger.debug("Unloading {}", plugin.getClass());
        this.plugins.remove(((Plugin)plugin).name);
        this.context.getEventRegister().unregister((Plugin)plugin);
        try {
            ((Plugin)plugin).close();
        }
        catch (Exception e) {
            this.pluginError(plugin, new SeverePluginException(e, false));
        }
        if (((Plugin)plugin).needsDatabase) {
            this.context.getDatabaseManager().unload((Plugin)plugin);
        }
        logger.warn(((Plugin)plugin).getDisplayInfo() + " unloaded");
    }

    private void pluginError(T plugin, Throwable error) {
        Throwable temp = error;
        if (error instanceof CompletionException && error.getCause() instanceof SeverePluginException) {
            temp = error.getCause();
        }
        Object header = "";
        if (temp instanceof SeverePluginException) {
            SeverePluginException pluginException = (SeverePluginException)temp;
            Marker m = MarkerFactory.getMarker((String)(pluginException.isFatal() ? "FATAL" : "SEVERE"));
            header = "Exception in " + ((Plugin)plugin).friendlyName;
            logger.error(m, (String)header, (Throwable)pluginException);
            if (pluginException.isFatal()) {
                this.unloadPlugin(plugin);
            }
        } else {
            header = "Error in " + ((Plugin)plugin).friendlyName;
            logger.error((String)header, temp);
        }
        this.context.pushNotification("An Error Occurred in Watame", (String)header + "\n\n" + ExceptionUtils.getStackTrace((Throwable)temp));
    }

    @Override
    public void close() {
        logger.debug("Closing all pugins");
        this.forEachPlugin(this::unloadPlugin, null);
    }

    public boolean isPluginPresent(String identifier) {
        return this.plugins.containsKey(identifier);
    }

    public boolean isPluginPresent(Class<? extends T> pluginClass) {
        return this.getPlugin(pluginClass) != null;
    }

    @Nullable
    public T getPlugin(String identifier) {
        return (T)((Plugin)this.plugins.get(identifier));
    }

    @Nullable
    public T getPlugin(Class<? extends T> pluginClass) {
        for (Plugin p : this.plugins.values()) {
            if (!pluginClass.isInstance(p)) continue;
            return (T)p;
        }
        return null;
    }

    @NotNull
    public Class<T> getPluginClass() {
        return this.pluginClass;
    }

    @NotNull
    public ModuleLayer getModuleLayer() {
        return this.layer;
    }

    @NotNull
    public ExecutorService getAsynchronousExecutor() {
        return this.pluginExecutor;
    }
}

