/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import net.foxgenesis.database.AbstractDatabase;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.PropertyType;
import net.foxgenesis.util.resource.ConfigType;
import net.foxgenesis.util.resource.ModuleResource;
import net.foxgenesis.util.resource.ResourceUtils;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.plugin.CommandProvider;
import net.foxgenesis.watame.plugin.IEventStore;
import net.foxgenesis.watame.plugin.PluginConfiguration;
import net.foxgenesis.watame.plugin.SeverePluginException;
import net.foxgenesis.watame.property.PluginProperty;
import net.foxgenesis.watame.property.PluginPropertyProvider;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Plugin {
    @NotNull
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final HashMap<String, PropertiesConfiguration> configs = new HashMap();
    @NotNull
    public final Path configurationPath;
    @NotNull
    public final String name;
    @NotNull
    public final String friendlyName;
    @NotNull
    public final String description;
    @NotNull
    public final ModuleDescriptor.Version version;
    public final boolean providesCommands;
    public final boolean needsDatabase;

    public Plugin() throws SeverePluginException {
        Class<?> c = this.getClass();
        Module module = c.getModule();
        if (!module.isNamed()) {
            throw new SeverePluginException("Plugin is not in a named module!");
        }
        Properties properties = new Properties();
        try (InputStream stream = module.getResourceAsStream("/plugin.properties");){
            properties.load(stream);
            this.name = Objects.requireNonNull(properties.getProperty("name"), "name must not be null!");
            this.friendlyName = Objects.requireNonNull(properties.getProperty("friendlyName"), "friendlyName must not be null!");
            this.version = ModuleDescriptor.Version.parse(Objects.requireNonNull(properties.getProperty("version"), "version must not be null!"));
            this.description = properties.getProperty("description", "No description provided");
            this.providesCommands = this instanceof CommandProvider;
            this.needsDatabase = properties.getProperty("needsDatabase", "false").equalsIgnoreCase("true");
            this.configurationPath = WatameBot.CONFIG_PATH.resolve(this.name);
        }
        catch (IOException e) {
            throw new SeverePluginException(e, true);
        }
        HashMap<String, Configuration> configs = new HashMap<String, Configuration>();
        if (c.isAnnotationPresent(PluginConfiguration.class)) {
            PluginConfiguration[] configDeclares;
            for (PluginConfiguration pluginConfig : configDeclares = (PluginConfiguration[])c.getDeclaredAnnotationsByType(PluginConfiguration.class)) {
                String id = pluginConfig.identifier();
                if (configs.containsKey(id)) continue;
                try {
                    ConfigType type = pluginConfig.type();
                    ModuleResource defaults = new ModuleResource(module, pluginConfig.defaultFile());
                    this.logger.debug("Loading {} configuration for {}", (Object)type.name(), (Object)pluginConfig.outputFile());
                    Configuration config = ResourceUtils.loadConfiguration(type, defaults, this.configurationPath, pluginConfig.outputFile());
                    configs.put(id, config);
                }
                catch (IOException | ConfigurationException e) {
                    throw new SeverePluginException(e, false);
                }
            }
        }
    }

    protected Set<String> configurationKeySet() {
        return this.configs.keySet();
    }

    protected void forEachConfiguration(BiConsumer<String, Configuration> consumer) {
        this.configs.entrySet().forEach(e -> consumer.accept((String)e.getKey(), (Configuration)e.getValue()));
    }

    protected boolean hasConfiguration(String identifier) {
        return this.configs.containsKey(identifier);
    }

    @Nullable
    protected Configuration getConfiguration(String identifier) {
        return this.configs.getOrDefault(identifier, null);
    }

    protected final PropertyInfo registerProperty(@NotNull String name, boolean modifiable, @NotNull PropertyType type) {
        return this.getPropertyProvider().registerProperty(this, name, modifiable, type);
    }

    protected final PluginProperty upsertProperty(@NotNull String name, boolean modifiable, @NotNull PropertyType type) {
        return this.getPropertyProvider().upsertProperty(this, name, modifiable, type);
    }

    protected final PluginProperty getProperty(PropertyInfo info) {
        return this.getPropertyProvider().getProperty(info);
    }

    protected final PluginProperty getProperty(String name) {
        return this.getPropertyProvider().getProperty(this, name);
    }

    protected final PluginPropertyProvider getPropertyProvider() {
        return WatameBot.INSTANCE.getPropertyProvider();
    }

    protected final void registerDatabase(AbstractDatabase database) throws IOException {
        WatameBot.INSTANCE.getDatabaseManager().register(this, database);
    }

    protected abstract void preInit() throws SeverePluginException;

    protected abstract void init(IEventStore var1) throws SeverePluginException;

    protected abstract void postInit(WatameBot var1) throws SeverePluginException;

    protected abstract void onReady(WatameBot var1) throws SeverePluginException;

    protected abstract void close() throws Exception;

    public String getDisplayInfo() {
        return this.friendlyName + " v" + this.version;
    }

    public String toString() {
        return "Plugin [name=" + this.name + ", friendlyName=" + this.friendlyName + ", description=" + this.description + ", version=" + this.version + ", providesCommands=" + this.providesCommands + ", needsDatabase=" + this.needsDatabase + ", configurationPath=" + this.configurationPath + "]";
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Plugin other = (Plugin)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version);
    }
}

