/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.plugin;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.foxgenesis.watame.plugin.IEventStore;
import net.foxgenesis.watame.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStore
implements IEventStore {
    private static final Logger logger = LoggerFactory.getLogger(EventStore.class);
    private final ConcurrentHashMap<Plugin, Set<Object>> store = new ConcurrentHashMap();
    private final JDABuilder builder;
    private JDA jda;

    public EventStore(JDABuilder builder) {
        this.builder = Objects.requireNonNull(builder);
    }

    public void register(Plugin plugin) {
        this.store.putIfAbsent(plugin, new HashSet());
    }

    public void unregister(Plugin plugin) {
        Objects.requireNonNull(plugin);
        Set<Object> objs = this.store.remove(plugin);
        if (objs != null && !objs.isEmpty()) {
            Object[] l = objs.toArray();
            logger.debug("Removing {} listeners from {}", (Object)l.length, (Object)plugin.friendlyName);
            this.builder.removeEventListeners(l);
            if (this.jda != null) {
                this.jda.removeEventListener(l);
            }
            objs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListeners(Plugin plugin, Object ... listener) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(listener);
        if (this.store.containsKey(plugin)) {
            Set<Object> listeners;
            Set<Object> set = listeners = this.store.get(plugin);
            synchronized (set) {
                logger.debug("Adding {} listeners from {}", (Object)listener.length, (Object)plugin.friendlyName);
                for (Object l : listener) {
                    listeners.add(l);
                }
                this.builder.addEventListeners(listener);
                if (this.jda != null) {
                    logger.debug("Adding {} listeners from {} to JDA", (Object)listener.length, (Object)plugin.friendlyName);
                    this.jda.addEventListener(listener);
                }
            }
        } else {
            throw new IllegalArgumentException("Provided plugin is not registered!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListeners(Plugin plugin, Object ... listener) {
        if (this.store.containsKey(plugin)) {
            Set<Object> listeners;
            Set<Object> set = listeners = this.store.get(plugin);
            synchronized (set) {
                logger.debug("Removing {} listeners from {}", (Object)listener.length, (Object)plugin.friendlyName);
                for (Object l : listener) {
                    listeners.remove(l);
                }
                this.builder.removeEventListeners(listener);
                if (this.jda != null) {
                    logger.debug("Removing {} listeners from {} in JDA", (Object)listener.length, (Object)plugin.friendlyName);
                    this.jda.removeEventListener(listener);
                }
            }
        } else {
            throw new IllegalArgumentException("Provided plugin is not registered!");
        }
    }

    public synchronized void setJDA(JDA jda) {
        this.jda = jda;
    }
}

