/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.command;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.AutoCompleteQuery;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.property.PluginProperty;
import net.foxgenesis.watame.property.PluginPropertyMapping;
import net.foxgenesis.watame.property.PluginPropertyProvider;
import net.foxgenesis.watame.util.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCommand
extends ListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger((String)"Configuration Command");
    private static final String DEFAULT = "Default";
    private static final String CONFIG_VALUE_FORMAT = "* %s = `%s`";

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        if (event.isFromGuild()) {
            switch (event.getName()) {
                case "options": {
                    ConfigCommand.handleOptions(event);
                }
            }
        }
    }

    public void onCommandAutoCompleteInteraction(CommandAutoCompleteInteractionEvent event) {
        AutoCompleteQuery option = event.getFocusedOption();
        Guild guild = event.getGuild();
        if (event.isFromGuild() && guild != null && event.getFullCommandName().startsWith("options configuration") && option.getName().equals("key")) {
            PluginPropertyProvider provider = WatameBot.INSTANCE.getPropertyProvider();
            String value = option.getValue().toLowerCase();
            List<Command.Choice> choices = provider.getPropertyList().stream().filter(PropertyInfo::modifiable).filter(info -> info.name().toLowerCase().contains(value)).map(info -> new Command.Choice(info.category() + " " + info.name(), (long)info.id())).limit(25L).toList();
            event.replyChoices(choices).queue();
        }
    }

    private static void handleOptions(SlashCommandInteractionEvent event) {
        String group;
        switch (group = Objects.requireNonNull(event.getSubcommandGroup())) {
            case "configuration": {
                ConfigCommand.handleConfiguration(event);
            }
        }
    }

    private static void handleConfiguration(SlashCommandInteractionEvent event) {
        PluginPropertyProvider provider = WatameBot.INSTANCE.getPropertyProvider();
        String sub = Objects.requireNonNull(event.getSubcommandName());
        InteractionHook hook = event.getHook();
        int tmp = sub.indexOf(45);
        if (tmp != -1) {
            sub = sub.substring(0, tmp);
        }
        switch (sub) {
            case "get": {
                ConfigCommand.getConfigurationSetting(event, provider, hook);
                break;
            }
            case "set": {
                ConfigCommand.setConfigurationSetting(event, provider, hook);
                break;
            }
            case "remove": {
                ConfigCommand.removeConfigurationSetting(event, provider, hook);
                break;
            }
            case "list": {
                ConfigCommand.listAllConfigurationSettings(event, provider, hook);
            }
        }
    }

    private static void getConfigurationSetting(SlashCommandInteractionEvent event, PluginPropertyProvider provider, InteractionHook hook) {
        event.deferReply(true).queue();
        ConfigCommand.ensureKey((Integer)event.getOption("key", OptionMapping::getAsInt), provider, hook, property -> {
            User user = event.getUser();
            logger.info("{}[{}] Checked configuration for {}", new Object[]{user.getName(), user.getId(), property.getInfo()});
            String pInfo = ConfigCommand.displayPropertyString(property.getInfo());
            String pValue = ConfigCommand.getUserFriendlyValue(property.get(event.getGuild()));
            hook.editOriginalEmbeds(new MessageEmbed[]{Response.info("\u2699 Configuration \u2699", CONFIG_VALUE_FORMAT.formatted(pInfo, pValue))}).queue();
        });
    }

    private static void setConfigurationSetting(SlashCommandInteractionEvent event, PluginPropertyProvider provider, InteractionHook hook) {
        event.deferReply(true).queue();
        ConfigCommand.ensureKey((Integer)event.getOption("key", OptionMapping::getAsInt), provider, hook, property -> ConfigCommand.ensureValue(event.getOptions(), hook, value -> {
            if (property.getInfo().modifiable()) {
                boolean wasSet;
                Member member = Objects.requireNonNull(event.getMember());
                Guild guild = member.getGuild();
                String key = ConfigCommand.displayPropertyString(property.getInfo());
                String old = ConfigCommand.getUserFriendlyValue(property.get(guild));
                switch (value.getType()) {
                    default: {
                        throw new IllegalArgumentException("Unexpected value: " + value.getType());
                    }
                    case BOOLEAN: {
                        boolean bl = property.set(guild, Boolean.valueOf(value.getAsBoolean()), true);
                        break;
                    }
                    case CHANNEL: {
                        boolean bl = property.set(guild, Long.valueOf(value.getAsChannel().getIdLong()), true);
                        break;
                    }
                    case INTEGER: {
                        boolean bl = property.set(guild, Integer.valueOf(value.getAsInt()), true);
                        break;
                    }
                    case ROLE: 
                    case USER: 
                    case MENTIONABLE: {
                        boolean bl = property.set(guild, Long.valueOf(value.getAsMentionable().getIdLong()), true);
                        break;
                    }
                    case NUMBER: {
                        boolean bl = property.set(guild, Long.valueOf(value.getAsLong()), true);
                        break;
                    }
                    case STRING: {
                        boolean bl = wasSet = property.set(guild, (Serializable)((Object)value.getAsString()), true);
                    }
                }
                if (wasSet) {
                    logger.info("{}[{}] Put {} -> {} into the configuration", new Object[]{member.getUser().getName(), member.getUser().getId(), key, value.getAsString()});
                    hook.editOriginalEmbeds(new MessageEmbed[]{Response.success("Set `%s` to `%s`".formatted(key, value.getAsString()))}).queue();
                    ConfigCommand.logChange(member, key, old, value.getAsString());
                } else {
                    ConfigCommand.unknownError(hook);
                }
            } else {
                hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Property is not user editable")}).queue();
            }
        }));
    }

    private static void removeConfigurationSetting(SlashCommandInteractionEvent event, PluginPropertyProvider provider, InteractionHook hook) {
        event.deferReply(true).queue();
        ConfigCommand.ensureKey((Integer)event.getOption("key", OptionMapping::getAsInt), provider, hook, property -> {
            if (property.getInfo().modifiable()) {
                Member member = Objects.requireNonNull(event.getMember());
                Guild guild = member.getGuild();
                String key = ConfigCommand.displayPropertyString(property.getInfo());
                String old = ConfigCommand.getUserFriendlyValue(property.get(guild));
                if (property.remove(guild, true)) {
                    logger.info("{}[{}] Removed {} from the configuration", new Object[]{member.getUser().getName(), member.getUser().getId(), property.getInfo()});
                    hook.editOriginalEmbeds(new MessageEmbed[]{Response.success("Set `%s` to `%s`".formatted(key, DEFAULT))}).queue();
                    ConfigCommand.logChange(member, key, old, DEFAULT);
                } else {
                    ConfigCommand.unknownError(hook);
                }
            } else {
                hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Property is not user editable")}).queue();
            }
        });
    }

    private static void listAllConfigurationSettings(SlashCommandInteractionEvent event, PluginPropertyProvider provider, InteractionHook hook) {
        event.deferReply(true).queue();
        Guild guild = event.getGuild();
        if (guild != null) {
            HashMap map = new HashMap();
            provider.getPropertyList().stream().map(info -> provider.getProperty((PropertyInfo)info)).forEach(property -> map.put(ConfigCommand.displayPropertyString(property.getInfo()), ConfigCommand.getUserFriendlyValue(property.get(guild))));
            StringBuilder builder = new StringBuilder();
            map.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).forEachOrdered(entry -> builder.append("* %s = `%s`\n".formatted(entry.getKey(), entry.getValue())));
            hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(2201331, "\u2699 Configuration List \u2699", builder.toString())}).queue();
        } else {
            ConfigCommand.unknownError(hook);
        }
    }

    private static void ensureKey(int id, PluginPropertyProvider provider, InteractionHook hook, @NotNull Consumer<PluginProperty> consumer) {
        if (id > 0) {
            try {
                consumer.accept(provider.getPropertyByID(id));
            }
            catch (NoSuchElementException e) {
                hook.editOriginalEmbeds(new MessageEmbed[]{Response.error("No property for id: " + id)}).queue();
            }
        } else {
            hook.editOriginalEmbeds(new MessageEmbed[]{Response.error("Invalid ID [" + id + "]. ID must be greater than 0.")}).queue();
        }
    }

    private static void ensureValue(@NotNull List<OptionMapping> mappings, @NotNull InteractionHook hook, @NotNull Consumer<OptionMapping> consumer) {
        for (OptionMapping m : mappings) {
            if (m.getName().equals("key")) continue;
            consumer.accept(m);
            return;
        }
        hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Unable to get value field")}).queue();
    }

    private static MessageEmbed response(int color, @NotNull String title, @Nullable String desc) {
        return new EmbedBuilder().setColor(color).setTitle(title).setDescription((CharSequence)desc).build();
    }

    private static void logChange(Member user, String key, String oldValue, String value) {
        GuildMessageChannel channel = WatameBot.INSTANCE.getLoggingChannel().get(user.getGuild(), PluginPropertyMapping::getAsMessageChannel);
        if (channel != null) {
            logger.debug("Logging configuration change to {}", (Object)channel);
            ((MessageCreateAction)((MessageCreateAction)channel.sendMessageEmbeds(new EmbedBuilder().setColor(16761095).setTitle("Configuration Change").setDescription((CharSequence)"Plugin configuration has been updated").addField("Type", value == null ? "Remove" : "Update", true).addField("User", user.getAsMention(), true).addField("Key", key, true).addField("Old Value", oldValue, true).addField("Value", value != null ? value : "N/A", true).build(), new MessageEmbed[0]).addCheck(() -> ((GuildMessageChannel)channel).canTalk())).addCheck(() -> user.hasPermission((GuildChannel)channel, new Permission[]{Permission.MESSAGE_EMBED_LINKS}))).queue();
        }
    }

    private static String displayPropertyString(PropertyInfo property) {
        return "[" + property.category() + "] " + property.name();
    }

    private static void unknownError(InteractionHook hook) {
        hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Something went wrong. Please try again later")}).queue();
    }

    private static String getUserFriendlyValue(Optional<? extends PluginPropertyMapping> value) {
        return value.map(property -> {
            if (property == null) {
                return "null";
            }
            if (property.isUserReadable()) {
                return property.getAsPlainText();
            }
            return "Object[" + property.getLength() + "B]";
        }).orElse(DEFAULT);
    }
}

