/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.foxgenesis.util.resource.ModuleResource;
import net.foxgenesis.util.resource.ResourceUtils;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatameBotSettings {
    @NotNull
    public final Path configurationPath;
    private final INIConfiguration config;
    private final String token;
    private final String pbToken;

    WatameBotSettings(@NotNull Path configPath) throws Exception {
        this(configPath, null, null);
    }

    WatameBotSettings(@NotNull Path configPath, @Nullable Path tokenFile2, String pbToken2) throws Exception {
        Path tokenFile;
        this.configurationPath = Objects.requireNonNull(configPath);
        if (!WatameBotSettings.isValidDirectory(configPath)) {
            throw new IOException("Invalid configuration directory");
        }
        this.config = ResourceUtils.loadINI(new ModuleResource(this.getClass().getModule(), "/META-INF/defaults/watamebot.ini"), this.configurationPath, "watamebot.ini");
        Path path = tokenFile = tokenFile2 == null ? Path.of(this.config.getString("Token.tokenFile", "token.txt"), new String[0]) : configPath.resolve(tokenFile2);
        if (!WatameBotSettings.isValidFile(tokenFile)) {
            throw new SettingsException("Invalid token file");
        }
        this.token = WatameBotSettings.readToken(tokenFile);
        String tmp = this.config.getString("PushBullet.token", pbToken2);
        this.pbToken = tmp != null && !tmp.isBlank() ? tmp.trim() : null;
    }

    public ImmutableConfiguration getConfiguration() {
        return this.config;
    }

    String getToken() {
        return this.token;
    }

    String getPBToken() {
        return this.pbToken;
    }

    private static String readToken(Path filepath) throws Exception {
        return Files.lines(filepath).filter(s -> !s.startsWith("#")).map(String::trim).findFirst().orElse("");
    }

    private static boolean isValidDirectory(Path path) throws SettingsException {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(path, new LinkOption[0]) && WatameBotSettings.check(Files.isDirectory(path, new LinkOption[0]), "Configuration path must be a directory!")) {
            return WatameBotSettings.check(Files.isReadable(path), "Unable to read from configuration directory!") && WatameBotSettings.check(Files.isWritable(path), "Unable to write to configuration directory!");
        }
        return false;
    }

    private static boolean isValidFile(Path path) throws SettingsException {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(path, new LinkOption[0]) && WatameBotSettings.check(Files.isRegularFile(path, new LinkOption[0]), "Token file must be a regular file!")) {
            return WatameBotSettings.check(Files.isReadable(path), "Unable to read from token file!");
        }
        return false;
    }

    private static boolean check(boolean toTest, String err) throws SettingsException {
        if (toTest) {
            return true;
        }
        throw new SettingsException(err);
    }

    public static class SettingsException
    extends Exception {
        private static final long serialVersionUID = 5228408925488573319L;

        public SettingsException(String msg) {
            super(msg);
        }
    }
}

