/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.exceptions.InvalidTokenException;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.utils.ChunkingFilter;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.foxgenesis.database.AConnectionProvider;
import net.foxgenesis.database.DatabaseManager;
import net.foxgenesis.database.IDatabaseManager;
import net.foxgenesis.database.providers.MySQLConnectionProvider;
import net.foxgenesis.property.PropertyType;
import net.foxgenesis.property.database.LCKConfigurationDatabase;
import net.foxgenesis.util.MethodTimer;
import net.foxgenesis.util.resource.ResourceUtils;
import net.foxgenesis.watame.Constants;
import net.foxgenesis.watame.Context;
import net.foxgenesis.watame.ExitCode;
import net.foxgenesis.watame.Main;
import net.foxgenesis.watame.PushBullet;
import net.foxgenesis.watame.WatameBotSettings;
import net.foxgenesis.watame.plugin.Plugin;
import net.foxgenesis.watame.plugin.PluginHandler;
import net.foxgenesis.watame.plugin.SeverePluginException;
import net.foxgenesis.watame.property.ImmutablePluginProperty;
import net.foxgenesis.watame.property.PluginProperty;
import net.foxgenesis.watame.property.PluginPropertyProvider;
import net.foxgenesis.watame.property.impl.PluginPropertyProviderImpl;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class WatameBot {
    public static final Logger logger = LoggerFactory.getLogger(WatameBot.class);
    public static final WatameBot INSTANCE;
    public static final Path CONFIG_PATH;
    private static final WatameBotSettings settings;
    private static final ImmutableConfiguration config;
    private static final PushBullet pushbullet;
    private JDABuilder builder;
    private JDA discord;
    private final DatabaseManager manager;
    private AConnectionProvider connectionProvider;
    private final LCKConfigurationDatabase propertyDatabase;
    private PluginPropertyProvider propertyProvider;
    private PluginProperty loggingChannel;
    private State state = State.CONSTRUCTING;
    private final PluginHandler<@NotNull Plugin> pluginHandler;
    private final Context context;

    private WatameBot(String token) {
        logger.debug("Adding shutdown hook");
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown, "WatameBot Shutdown Thread"));
        this.manager = new DatabaseManager("Database Manager");
        try {
            this.connectionProvider = this.getConnectionProvider();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.propertyDatabase = new LCKConfigurationDatabase(this.connectionProvider.getDatabase(), "Properties", "PropertyInfo");
        this.propertyProvider = new PluginPropertyProviderImpl(this.propertyDatabase, 300000L);
        this.builder = this.createJDA(token, null);
        this.context = new Context(this, this.builder, null, pushbullet::pushPBMessage);
        this.pluginHandler = new PluginHandler<Plugin>(this.context, this.getClass().getModule().getLayer(), Plugin.class);
    }

    void start() throws Exception {
        try {
            long start = System.nanoTime();
            this.updateState(State.CONSTRUCTING);
            logger.info("Starting");
            this.construct();
            this.updateState(State.PRE_INIT);
            logger.info("Calling pre-initialization");
            this.preInit();
            this.updateState(State.INIT);
            logger.info("Calling initialization");
            this.init();
            this.updateState(State.POST_INIT);
            logger.info("Calling post-initialization");
            this.postInit();
            long end = System.nanoTime();
            this.updateState(State.RUNNING);
            logger.info("Startup completed in {} seconds", (Object)MethodTimer.formatToSeconds(end - start));
            logger.info("Calling on ready");
            this.ready();
        }
        catch (Exception e) {
            pushbullet.pushPBMessage("An Error Occurred in Watame", ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    private void construct() throws Exception {
        this.pluginHandler.loadPlugins();
        try {
            Plugin integrated = this.pluginHandler.getPlugin("integrated");
            if (integrated == null) {
                throw new SeverePluginException("Failed to find the integrated plugin!");
            }
            this.manager.register(integrated, this.propertyDatabase);
        }
        catch (IOException e) {
            ExitCode.DATABASE_SETUP_ERROR.programExit(e);
        }
        catch (IllegalArgumentException e) {
            ExitCode.DATABASE_INVALID_SETUP_FILE.programExit(e);
        }
    }

    private void preInit() throws Exception {
        this.pluginHandler.preInit();
        logger.info("Starting database pool");
        this.manager.start(this.connectionProvider);
    }

    private void init() throws Exception {
        Plugin integrated = this.pluginHandler.getPlugin("integrated");
        if (integrated != null) {
            this.loggingChannel = this.propertyProvider.upsertProperty(integrated, "modlog", true, PropertyType.NUMBER);
        }
        this.pluginHandler.init();
    }

    private void postInit() throws Exception {
        this.pluginHandler.postInit(this);
        this.discord = this.buildJDA();
        this.context.onJDABuilder(this.discord);
        logger.info("Collecting commands...");
        this.pluginHandler.updateCommands(this.discord.updateCommands()).queue();
        if (this.discord.getStatus() != JDA.Status.CONNECTED) {
            try {
                logger.info("Waiting for JDA to be ready...");
                this.discord.awaitReady();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.info("Connected to discord!");
    }

    private void ready() {
        logger.debug("Setting presence to ready");
        this.discord.getPresence().setPresence(OnlineStatus.ONLINE, Activity.playing((String)config.getString("WatameBot.Status.online", "https://github.com/FoxGenesis/Watamebot")));
        this.pluginHandler.onReady(this);
    }

    private void shutdown() {
        this.updateState(State.SHUTDOWN);
        System.out.println();
        logger.info("Shutting down...");
        IOUtil.silentClose(this.pluginHandler);
        if (this.discord != null) {
            logger.info("Shutting down JDA...");
            this.discord.shutdown();
        }
        try {
            logger.info("Closing database connection");
            if (this.manager != null) {
                this.manager.close();
            }
        }
        catch (Exception e) {
            logger.error("Error while closing database connection!", (Throwable)e);
        }
        if (!ForkJoinPool.commonPool().awaitQuiescence(1L, TimeUnit.MINUTES)) {
            logger.warn("Timed out waiting for common pool shutdown. Continuing shutdown...");
        }
        logger.info("Exiting...");
    }

    private JDABuilder createJDA(String token, ExecutorService eventExecutor) {
        Objects.requireNonNull(token, "Login token must not be null");
        logger.debug("Creating JDA");
        JDABuilder builder = JDABuilder.create((String)token, (GatewayIntent)GatewayIntent.GUILD_MEMBERS, (GatewayIntent[])new GatewayIntent[]{GatewayIntent.GUILD_MODERATION, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_VOICE_STATES}).disableCache(CacheFlag.ACTIVITY, new CacheFlag[]{CacheFlag.EMOJI, CacheFlag.STICKER, CacheFlag.CLIENT_STATUS, CacheFlag.ONLINE_STATUS, CacheFlag.SCHEDULED_EVENTS}).setChunkingFilter(ChunkingFilter.ALL).setAutoReconnect(true).setActivity(Activity.playing((String)config.getString("WatameBot.Status.startup", "Initalizing..."))).setMemberCachePolicy(MemberCachePolicy.ALL).setStatus(OnlineStatus.DO_NOT_DISTURB).setEnableShutdownHook(false);
        if (eventExecutor != null) {
            builder.setEventPool(eventExecutor, true);
        }
        return builder;
    }

    private JDA buildJDA() throws Exception {
        JDA discordTmp = null;
        int tries = 0;
        int maxTries = 5;
        double delay = 2.0;
        while (++tries < maxTries) {
            if (tries > 1) {
                delay = Math.pow(delay, tries);
                logger.warn("Retrying in " + delay + " seconds...");
                Thread.sleep((long)delay * 1000L);
            }
            try {
                logger.info("Attempting to login to discord");
                discordTmp = this.builder.build();
                break;
            }
            catch (InvalidTokenException e) {
                ExitCode.INVALID_TOKEN.programExit(e.getLocalizedMessage());
            }
            catch (Exception ex) {
                logger.error("Failed to connect: " + ex.getLocalizedMessage());
            }
        }
        if (discordTmp == null) {
            ExitCode.JDA_BUILD_FAIL.programExit("Failed to build JDA after " + maxTries + " tries");
            return null;
        }
        return discordTmp;
    }

    private AConnectionProvider getConnectionProvider() throws Exception {
        MySQLConnectionProvider provider = null;
        int tries = 0;
        int maxTries = 5;
        double delay = 2.0;
        Properties properties = ResourceUtils.getProperties(WatameBot.settings.configurationPath.resolve("database.properties"), Constants.DATABASE_SETTINGS_FILE);
        while (tries < maxTries && provider == null) {
            if ((delay = Math.pow(delay, tries)) > 1.0) {
                try {
                    logger.info("Retrying in {} seconds...", (Object)delay);
                    Thread.sleep((long)delay * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                ++tries;
                provider = new MySQLConnectionProvider(properties);
            }
            catch (ConnectException e) {
                logger.error("Failed to connect to database: {}", (Object)e.getLocalizedMessage());
            }
        }
        if (provider == null) {
            ExitCode.DATABASE_SETUP_ERROR.programExit("Failed to connect to the database after " + maxTries + " tries");
        }
        return provider;
    }

    public boolean isConnectedToDiscord() {
        return this.discord != null && this.discord.getStatus() == JDA.Status.CONNECTED;
    }

    public IDatabaseManager getDatabaseManager() {
        return this.manager;
    }

    public PluginPropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    public ImmutablePluginProperty getLoggingChannel() {
        return this.loggingChannel;
    }

    public JDA getJDA() {
        return this.discord;
    }

    public State getState() {
        return this.state;
    }

    private void updateState(State state) {
        this.state = state;
        logger.trace("STATE = " + state);
        System.setProperty("watame.status", state.name());
    }

    static {
        settings = Main.getSettings();
        config = settings.getConfiguration();
        pushbullet = new PushBullet(settings.getPBToken());
        RestAction.setDefaultFailure(err -> pushbullet.pushPBMessage("An Error Occurred in Watame", ExceptionUtils.getStackTrace((Throwable)err)));
        CONFIG_PATH = WatameBot.settings.configurationPath;
        INSTANCE = new WatameBot(settings.getToken());
    }

    public static enum State {
        CONSTRUCTING,
        PRE_INIT,
        INIT,
        POST_INIT,
        RUNNING,
        SHUTDOWN;

        public final Marker marker = MarkerFactory.getMarker((String)this.name());
    }
}

