/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushBullet {
    private static final Logger logger = LoggerFactory.getLogger(PushBullet.class);
    private OkHttpClient client;
    private final String token;

    public PushBullet(String token) {
        this(new OkHttpClient().newBuilder().build(), token);
    }

    public PushBullet(@NotNull OkHttpClient client, String token) {
        this.client = Objects.requireNonNull(client);
        this.token = token;
    }

    public void pushPBMessage(String title, String message) {
        if (this.token != null) {
            try {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("type", "note");
                param.put("title", title);
                param.put("body", message);
                ((CompletableFuture)PushBullet.submit(this.client, PushBullet.newRequest(this.token, param)).thenAccept(r -> r.close())).join();
            }
            catch (Exception e) {
                logger.error("Error while pushing to PushBullet", (Throwable)e);
            }
        }
    }

    private static Request newRequest(String token, Map<String, String> params) throws JsonProcessingException {
        Request.Builder builder = new Request.Builder();
        builder.url("https://api.pushbullet.com/v2/pushes");
        ObjectMapper mapper = new ObjectMapper();
        RequestBody b = RequestBody.create((byte[])mapper.writeValueAsBytes(params));
        builder.addHeader("Content-Type", "application/json");
        builder.post(b);
        builder.addHeader("Access-Token", token);
        return builder.build();
    }

    private static CompletableFuture<Response> submit(OkHttpClient client, Request request) {
        Objects.requireNonNull(client);
        final CompletableFuture<Response> callback = new CompletableFuture<Response>();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call arg0, IOException arg1) {
                callback.completeExceptionally(arg1);
            }

            public void onResponse(Call arg0, Response arg1) throws IOException {
                callback.complete(arg1);
            }
        });
        return callback;
    }
}

