/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.lck.impl;

import java.util.List;
import java.util.Objects;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.PropertyType;
import net.foxgenesis.property.lck.LCKProperty;
import net.foxgenesis.property.lck.LCKPropertyProvider;
import net.foxgenesis.property.lck.LCKPropertyResolver;
import net.foxgenesis.property.lck.impl.LCKPropertyImpl;

public class LCKPropertyProviderImpl
implements LCKPropertyProvider {
    private final LCKPropertyResolver database;

    public LCKPropertyProviderImpl(LCKPropertyResolver database) {
        this.database = Objects.requireNonNull(database);
    }

    @Override
    public PropertyInfo registerProperty(String category, String key, boolean modifiable, PropertyType type) {
        if (!this.propertyExists(category, key)) {
            return this.database.createPropertyInfo(category, key, modifiable, type);
        }
        return this.database.getPropertyInfo(category, key);
    }

    public LCKProperty getPropertyByID(int id) {
        return this.getProperty(this.database.getPropertyByID(id));
    }

    public LCKProperty getProperty(String category, String key) {
        return this.getProperty(this.database.getPropertyInfo(category, key));
    }

    public LCKProperty getProperty(PropertyInfo info) {
        return new LCKPropertyImpl(info, this.database);
    }

    @Override
    public boolean propertyExists(String category, String key) {
        return this.database.isRegistered(category, key);
    }

    @Override
    public List<PropertyInfo> getPropertyList() {
        return this.database.getPropertyList();
    }
}

