/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.lck.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import net.foxgenesis.property.Property;
import net.foxgenesis.property.PropertyException;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.lck.LCKProperty;
import net.foxgenesis.property.lck.LCKPropertyResolver;
import net.foxgenesis.property.lck.impl.BlobMapping;

public class LCKPropertyImpl
implements LCKProperty {
    private final PropertyInfo info;
    protected final LCKPropertyResolver resolver;

    public LCKPropertyImpl(PropertyInfo info, LCKPropertyResolver resolver) {
        this.info = Objects.requireNonNull(info);
        this.resolver = Objects.requireNonNull(resolver);
    }

    @Override
    public Optional<BlobMapping> get(Long lookup) {
        return this.resolver.getInternal(lookup, this.info).map(t -> {
            try {
                return new BlobMapping((long)lookup, (Blob)t, this.getInfo().type());
            }
            catch (IOException | SQLException e) {
                throw new PropertyException(e);
            }
        });
    }

    @Override
    public boolean set(Long lookup, Serializable obj, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        return this.set(lookup, Property.serialize(this.getInfo(), obj), isUserInput);
    }

    @Override
    public boolean set(Long lookup, byte[] data, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        return this.set(lookup, (InputStream)new ByteArrayInputStream(data), isUserInput);
    }

    @Override
    public boolean set(Long lookup, InputStream in, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        return this.resolver.putInternal(lookup, this.info, in);
    }

    @Override
    public boolean remove(Long lookup, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        return this.resolver.removeInternal(lookup, this.info);
    }

    @Override
    public boolean isPresent(Long lookup) {
        return this.resolver.isPresent(lookup, this.info);
    }

    @Override
    public PropertyInfo getInfo() {
        return this.info;
    }

    public int hashCode() {
        return Objects.hash(this.info, this.resolver);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LCKPropertyImpl other = (LCKPropertyImpl)obj;
        return Objects.equals(this.info, other.info) && Objects.equals(this.resolver, other.resolver);
    }

    public String toString() {
        return "LCKProperty [" + (String)(this.info != null ? "info=" + this.info + ", " : "") + (String)(this.resolver != null ? "resolver=" + this.resolver : "") + "]";
    }
}

