/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.lck.impl;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CachedObject<T> {
    private final AtomicReference<T> obj = new AtomicReference();
    private final AtomicLong lastCache = new AtomicLong();
    private final Supplier<T> updateFunction;
    private final long cacheTime;

    public CachedObject(Supplier<T> updateFunction, long cacheTime) {
        this.updateFunction = Objects.requireNonNull(updateFunction);
        this.cacheTime = cacheTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T get() {
        long time = System.currentTimeMillis();
        if (time - this.lastCache.get() > this.cacheTime) {
            CachedObject cachedObject = this;
            synchronized (cachedObject) {
                if (time - this.lastCache.get() > this.cacheTime) {
                    return this.getNew();
                }
            }
        }
        return this.obj.get();
    }

    @Nullable
    public synchronized T getNew() {
        return this.set(this.updateFunction.get());
    }

    @Nullable
    public synchronized T set(T newValue) {
        this.lastCache.set(System.currentTimeMillis());
        this.obj.set(newValue);
        return newValue;
    }

    public void invalidate() {
        this.lastCache.set(0L);
    }

    public long getCacheTime() {
        return this.cacheTime;
    }
}

