/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.lck.impl;

import java.io.IOException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.foxgenesis.property.PropertyException;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.lck.LCKPropertyResolver;
import net.foxgenesis.property.lck.impl.BlobMapping;
import net.foxgenesis.property.lck.impl.CachedObject;
import net.foxgenesis.property.lck.impl.LCKPropertyImpl;

public class CachedLCKProperty
extends LCKPropertyImpl {
    protected final ConcurrentHashMap<Long, CachedObject<Optional<BlobMapping>>> cache = new ConcurrentHashMap();
    private final long cacheTime;

    public CachedLCKProperty(PropertyInfo info, LCKPropertyResolver resolver, long cacheTime) {
        super(info, resolver);
        this.cacheTime = cacheTime;
    }

    @Override
    public Optional<BlobMapping> get(Long lookup) {
        this.init(lookup);
        Optional<BlobMapping> map = this.cache.get(lookup).get();
        if (map != null) {
            return map;
        }
        return Optional.empty();
    }

    @Override
    public boolean set(Long lookup, byte[] data, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        this.init(lookup);
        if (super.set(lookup, data, isUserInput)) {
            this.cache.get(lookup).set(Optional.ofNullable(this.createMapping(lookup, data)));
            return true;
        }
        return false;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    protected void init(long lookup) {
        if (!this.cache.containsKey(lookup)) {
            this.cache.put(lookup, this.newCache(lookup));
        }
    }

    private CachedObject<Optional<BlobMapping>> newCache(long lookup) {
        return new CachedObject<Optional<BlobMapping>>(() -> this.retrieve(lookup), this.cacheTime);
    }

    private Optional<BlobMapping> retrieve(Long lookup) {
        return this.resolver.getInternal(lookup, this.getInfo()).map(b -> this.createMapping(lookup, (Blob)b));
    }

    protected BlobMapping createMapping(Long lookup, Blob blob) throws PropertyException {
        if (blob == null) {
            return null;
        }
        try {
            return new BlobMapping((long)lookup, blob, this.getInfo().type());
        }
        catch (IOException | SQLException e) {
            throw new PropertyException(e);
        }
    }

    protected BlobMapping createMapping(Long lookup, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new BlobMapping((long)lookup, data, this.getInfo().type());
    }
}

