/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.lck.impl;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import net.foxgenesis.property.PropertyMapping;
import net.foxgenesis.property.PropertyType;
import org.jetbrains.annotations.NotNull;

public class BlobMapping
implements PropertyMapping {
    private final byte[] data;
    private final long lookup;
    private final PropertyType type;

    public BlobMapping(long lookup, byte[] data, @NotNull PropertyType type) {
        this.lookup = lookup;
        this.data = Objects.requireNonNull(data);
        this.type = Objects.requireNonNull(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobMapping(long lookup, @NotNull Blob blob, @NotNull PropertyType type) throws IOException, SQLException {
        this.lookup = lookup;
        this.type = Objects.requireNonNull(type);
        try (InputStream in = blob.getBinaryStream();){
            this.data = in.readAllBytes();
        }
        finally {
            blob.free();
        }
    }

    @Override
    public String getAsPlainText() {
        if (this.type == PropertyType.NUMBER) {
            return new BigInteger(this.data).toString();
        }
        return new String(this.data);
    }

    @Override
    public Object getAsObject() {
        return PropertyMapping.parse(Object.class, this.data);
    }

    @Override
    public String getAsString() {
        if (this.isUserReadable()) {
            return this.getAsPlainText();
        }
        return PropertyMapping.parse(String.class, this.data);
    }

    @Override
    public boolean getAsBoolean() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.OBJECT -> PropertyMapping.parse(Boolean.class, this.data);
            case PropertyType.PLAIN -> Boolean.parseBoolean(this.getAsPlainText());
            case PropertyType.NUMBER -> new BigInteger(this.data).testBit(0);
        };
    }

    @Override
    public int getAsInt() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.OBJECT -> PropertyMapping.parse(Integer.class, this.data);
            case PropertyType.PLAIN -> Integer.parseInt(this.getAsPlainText());
            case PropertyType.NUMBER -> new BigInteger(this.data).intValue();
        };
    }

    @Override
    public float getAsFloat() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.OBJECT -> PropertyMapping.parse(Float.class, this.data).floatValue();
            case PropertyType.PLAIN -> Float.parseFloat(this.getAsPlainText());
            case PropertyType.NUMBER -> new BigInteger(this.data).floatValue();
        };
    }

    @Override
    public double getAsDouble() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.OBJECT -> PropertyMapping.parse(Double.class, this.data);
            case PropertyType.PLAIN -> Double.parseDouble(this.getAsPlainText());
            case PropertyType.NUMBER -> new BigInteger(this.data).doubleValue();
        };
    }

    @Override
    public long getAsLong() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.OBJECT -> PropertyMapping.parse(Long.class, this.data);
            case PropertyType.PLAIN -> Long.parseLong(this.getAsPlainText());
            case PropertyType.NUMBER -> new BigInteger(this.data).longValue();
        };
    }

    @Override
    public String[] getAsStringArray() {
        if (this.isUserReadable()) {
            return (String[])PropertyMapping.unjoin(this.getAsPlainText(), Function.identity(), String[]::new);
        }
        return PropertyMapping.parse(String[].class, this.data);
    }

    @Override
    public boolean[] getAsBooleanArray() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.NUMBER -> {
                boolean[] out = new boolean[this.data.length];
                for (int i = 0; i < this.data.length; ++i) {
                    out[i] = (this.data[i] & 1) == 1;
                }
                yield out;
            }
            case PropertyType.OBJECT -> PropertyMapping.parse(boolean[].class, this.data);
            case PropertyType.PLAIN -> PropertyMapping.unjoinBoolean(this.getAsPlainText());
        };
    }

    @Override
    public int[] getAsIntegerArray() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.NUMBER -> {
                ByteBuffer b = ByteBuffer.wrap(this.data);
                int[] out = new int[this.data.length / 4];
                int i = 0;
                while (b.hasRemaining()) {
                    out[i] = b.getInt();
                    ++i;
                }
                yield out;
            }
            case PropertyType.OBJECT -> PropertyMapping.parse(int[].class, this.data);
            case PropertyType.PLAIN -> PropertyMapping.unjoinInt(this.getAsPlainText());
        };
    }

    @Override
    public float[] getAsFloatArray() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.NUMBER -> {
                ByteBuffer b = ByteBuffer.wrap(this.data);
                float[] out = new float[this.data.length / 4];
                int i = 0;
                while (b.hasRemaining()) {
                    out[i] = b.getFloat();
                    ++i;
                }
                yield out;
            }
            case PropertyType.OBJECT -> PropertyMapping.parse(float[].class, this.data);
            case PropertyType.PLAIN -> PropertyMapping.unjoinFloat(this.getAsPlainText());
        };
    }

    @Override
    public double[] getAsDoubleArray() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.NUMBER -> {
                ByteBuffer b = ByteBuffer.wrap(this.data);
                double[] out = new double[this.data.length / 8];
                int i = 0;
                while (b.hasRemaining()) {
                    out[i] = b.getDouble();
                    ++i;
                }
                yield out;
            }
            case PropertyType.OBJECT -> PropertyMapping.parse(double[].class, this.data);
            case PropertyType.PLAIN -> PropertyMapping.unjoinDouble(this.getAsPlainText());
        };
    }

    @Override
    public long[] getAsLongArray() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.NUMBER -> {
                ByteBuffer b = ByteBuffer.wrap(this.data);
                long[] out = new long[this.data.length / 8];
                int i = 0;
                while (b.hasRemaining()) {
                    out[i] = b.getLong();
                    ++i;
                }
                yield out;
            }
            case PropertyType.OBJECT -> PropertyMapping.parse(long[].class, this.data);
            case PropertyType.PLAIN -> PropertyMapping.unjoinLong(this.getAsPlainText());
        };
    }

    @Override
    public byte[] getAsByteArray() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.NUMBER -> Arrays.copyOf(this.data, this.data.length);
            case PropertyType.OBJECT -> PropertyMapping.parse(byte[].class, this.data);
            case PropertyType.PLAIN -> PropertyMapping.unjoinByte(this.getAsPlainText());
        };
    }

    @Override
    public PropertyType getType() {
        return this.type;
    }

    public long getLookup() {
        return this.lookup;
    }

    @Override
    public long getLength() {
        return this.data.length;
    }
}

