/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.database;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import net.foxgenesis.database.AbstractDatabase;
import net.foxgenesis.property.PropertyException;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.PropertyType;
import net.foxgenesis.property.lck.LCKPropertyResolver;
import net.foxgenesis.util.resource.FormattedModuleResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LCKConfigurationDatabase
extends AbstractDatabase
implements LCKPropertyResolver {
    public static final int MAX_CATEGORY_LENGTH = 50;
    public static final int MAX_KEY_LENGTH = 500;
    private final String database;
    private final String table;
    private final String propertyInfoTable;

    public LCKConfigurationDatabase(String database, String propertyTable, String propertyInfoTable) {
        super("LCK Configuration", new FormattedModuleResource("watamebot", "/META-INF/configDatabase/statements.kvp", Map.of("database", database, "table", propertyTable, "table2", propertyInfoTable)), new FormattedModuleResource("watamebot", "/META-INF/configDatabase/setup.sql", Map.of("database", database, "table", propertyTable, "table2", propertyInfoTable)));
        this.database = Objects.requireNonNull(database);
        this.table = Objects.requireNonNull(propertyTable);
        this.propertyInfoTable = Objects.requireNonNull(propertyInfoTable);
    }

    @Override
    public boolean removeInternal(Long lookup, PropertyInfo info) throws PropertyException {
        this.validate(lookup, info);
        this.logger.debug("Removing property: {}", (Object)info);
        try {
            return this.mapStatement("property_delete", statement -> {
                statement.setLong(1, lookup);
                statement.setInt(2, info.id());
                return statement.executeUpdate() > 0;
            }, new int[0]).orElse(false);
        }
        catch (SQLException e) {
            throw new PropertyException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean putInternal(Long lookup, PropertyInfo info, InputStream in) throws PropertyException {
        try (InputStream inputStream = in;){
            this.validate(lookup, info);
            if (in == null) {
                boolean bl2 = this.removeInternal(lookup, info);
                return bl2;
            }
            this.logger.debug("Setting property: {}", (Object)info);
            boolean bl = this.mapStatement("property_insert_update", statement -> {
                statement.setLong(1, lookup);
                statement.setInt(2, info.id());
                statement.setBlob(3, in);
                return statement.executeUpdate() > 0;
            }, new int[0]).orElse(false);
            return bl;
        }
        catch (Exception e) {
            throw new PropertyException(e);
        }
    }

    @Override
    public Optional<Blob> getInternal(Long lookup, PropertyInfo info) throws PropertyException {
        this.validate(lookup, info);
        this.logger.debug("Getting property: {}", (Object)info);
        try {
            return this.mapStatement("property_read", statement -> {
                statement.setLong(1, lookup);
                statement.setInt(2, info.id());
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        Blob blob = result.getBlob("property");
                        return blob;
                    }
                    Blob blob = null;
                    return blob;
                }
            }, new int[0]);
        }
        catch (SQLException e) {
            throw new PropertyException(e);
        }
    }

    @Override
    public boolean isPresent(Long lookup, PropertyInfo info) throws PropertyException {
        this.validate(lookup, info);
        try {
            return this.mapStatement("property_exists", statement -> {
                statement.setLong(1, lookup);
                statement.setInt(2, info.id());
                try (ResultSet result = statement.executeQuery();){
                    Boolean bl = result.next();
                    return bl;
                }
            }, new int[0]).orElse(false);
        }
        catch (SQLException e) {
            throw new PropertyException(e);
        }
    }

    @Override
    public PropertyInfo createPropertyInfo(String category, String key, boolean modifiable, PropertyType type) throws PropertyException, IllegalArgumentException {
        this.validate(category, key);
        this.logger.debug("Creating property: [{}] {} (modifiable: {}, type: {})", new Object[]{category, key, modifiable, type});
        try {
            return this.mapStatement("property_info_create", statement -> {
                statement.setString(1, category);
                statement.setString(2, key);
                statement.setBoolean(3, modifiable);
                statement.setString(4, type.name().toLowerCase());
                if (statement.executeUpdate() > 0) {
                    try (ResultSet result = statement.getGeneratedKeys();){
                        result.next();
                        Integer n = result.getInt(1);
                        return n;
                    }
                }
                return -1;
            }, 1).filter(id -> id != -1).map(id -> new PropertyInfo((int)id, category, key, modifiable, type)).orElseThrow(() -> new IllegalArgumentException("Property already exists"));
        }
        catch (SQLException e) {
            throw new PropertyException(e);
        }
    }

    @Override
    public boolean removePropertyInfo(@NotNull String category, @NotNull String key) {
        this.validate(category, key);
        this.logger.debug("Deleting property: [{}] {}", (Object)category, (Object)key);
        try {
            return this.mapStatement("property_info_delete", statement -> {
                statement.setString(1, category);
                statement.setString(2, key);
                return statement.executeUpdate() > 0;
            }, new int[0]).orElse(false);
        }
        catch (SQLException e) {
            throw new PropertyException(e);
        }
    }

    @Override
    public boolean removePropertyInfo(@NotNull PropertyInfo info) {
        return this.removePropertyInfo(info.category(), info.name());
    }

    @Override
    public PropertyInfo getPropertyByID(int id) throws PropertyException, NoSuchElementException {
        if (id < 0) {
            throw new PropertyException("Invalid property id");
        }
        if (!this.isReady()) {
            throw new PropertyException("Database is not ready yet!");
        }
        this.logger.debug("Getting property for id: {}", (Object)id);
        try {
            return this.mapStatement("property_info_read_by_id", statement -> {
                statement.setInt(1, id);
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        PropertyInfo propertyInfo = LCKConfigurationDatabase.parsePropertyInfo(result);
                        return propertyInfo;
                    }
                    PropertyInfo propertyInfo = null;
                    return propertyInfo;
                }
            }, new int[0]).orElseThrow();
        }
        catch (SQLException e) {
            throw new PropertyException(e);
        }
    }

    @Override
    public boolean isRegistered(String category, String key) throws PropertyException {
        this.validate(category, key);
        this.logger.debug("Checking for existing property [{}] {}", (Object)category, (Object)key);
        try {
            return this.mapStatement("property_info_exists", statement -> {
                statement.setString(1, category);
                statement.setString(2, key);
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        Boolean bl = result.getBoolean(1);
                        return bl;
                    }
                    Boolean bl = false;
                    return bl;
                }
            }, new int[0]).orElse(false);
        }
        catch (SQLException e) {
            throw new PropertyException(e);
        }
    }

    @Override
    @NotNull
    public PropertyInfo getPropertyInfo(String category, String key) throws PropertyException, NoSuchElementException {
        this.validate(category, key);
        this.logger.debug("Getting property info for [{}] {}", (Object)category, (Object)key);
        try {
            return this.mapStatement("property_info_read", statement -> {
                statement.setString(1, category);
                statement.setString(2, key);
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        PropertyInfo propertyInfo = LCKConfigurationDatabase.parsePropertyInfo(result);
                        return propertyInfo;
                    }
                    PropertyInfo propertyInfo = null;
                    return propertyInfo;
                }
            }, new int[0]).orElseThrow();
        }
        catch (SQLException e) {
            throw new PropertyException(e);
        }
    }

    @Override
    public List<PropertyInfo> getPropertyList() throws PropertyException {
        this.logger.debug("Getting property list");
        try {
            ArrayList<PropertyInfo> list = new ArrayList<PropertyInfo>();
            this.prepareStatement("property_info_get_all", statement -> {
                try (ResultSet result = statement.executeQuery();){
                    while (result.next()) {
                        list.add(LCKConfigurationDatabase.parsePropertyInfo(result));
                    }
                }
            }, new int[0]);
            return list;
        }
        catch (SQLException e) {
            throw new PropertyException(e);
        }
    }

    @Override
    protected void onReady() {
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public String getDatabase() {
        return this.database;
    }

    @NotNull
    public String getPropertyTable() {
        return this.table;
    }

    @NotNull
    public String getPropertyInfoTable() {
        return this.propertyInfoTable;
    }

    protected boolean isValidLookup(long lookup) {
        return Math.floor(Math.log10(lookup)) + 1.0 == 18.0;
    }

    private void validate(long lookup, @Nullable PropertyInfo info) {
        if (!this.isValidLookup(lookup)) {
            throw new PropertyException("Invalid lookup");
        }
        Objects.requireNonNull(info);
        this.validate(info.category(), info.name());
    }

    private void validate(String category, String key) {
        if (category.isBlank() || key.isBlank()) {
            throw new IllegalArgumentException("Category and key can not be blank!");
        }
        if (category.length() > 50) {
            throw new IllegalArgumentException("Category length can not exceed 50 characters");
        }
        if (key.length() > 500) {
            throw new IllegalArgumentException("Key length can not exceed 500 characters");
        }
        if (!this.isReady()) {
            throw new PropertyException("Database is not ready yet!");
        }
    }

    private static PropertyInfo parsePropertyInfo(ResultSet result) throws SQLException {
        int id = result.getInt(1);
        String category = result.getString(2);
        String name = result.getString(3);
        boolean modifiable = result.getBoolean(4);
        PropertyType type = PropertyType.valueOf(result.getString(5).toUpperCase());
        return new PropertyInfo(id, category, name, modifiable, type);
    }
}

