/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.foxgenesis.property.PropertyException;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyResolver<L, C, K> {
    public static final int MAX_CATEGORY_LENGTH = 50;
    public static final int MAX_KEY_LENGTH = 500;

    public PropertyInfo createPropertyInfo(@NotNull C var1, @NotNull K var2, boolean var3, @NotNull PropertyType var4) throws PropertyException, IllegalArgumentException;

    public boolean removePropertyInfo(@NotNull C var1, @NotNull K var2);

    public boolean removePropertyInfo(@NotNull PropertyInfo var1);

    public boolean isRegistered(@NotNull C var1, @NotNull K var2) throws PropertyException;

    public PropertyInfo getPropertyByID(int var1) throws PropertyException, NoSuchElementException;

    public PropertyInfo getPropertyInfo(@NotNull C var1, @NotNull K var2) throws PropertyException, NoSuchElementException;

    @NotNull
    public List<PropertyInfo> getPropertyList() throws PropertyException;

    public boolean removeInternal(@NotNull L var1, @NotNull PropertyInfo var2) throws PropertyException;

    public boolean putInternal(@NotNull L var1, @NotNull PropertyInfo var2, @Nullable InputStream var3) throws PropertyException;

    @NotNull
    public Optional<?> getInternal(@NotNull L var1, @NotNull PropertyInfo var2) throws PropertyException;

    public boolean isPresent(@NotNull L var1, @NotNull PropertyInfo var2) throws PropertyException;
}

