/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.foxgenesis.property.PropertyException;
import net.foxgenesis.property.PropertyType;
import org.apache.commons.lang3.SerializationUtils;

public interface PropertyMapping {
    public String getAsPlainText();

    public Object getAsObject();

    public String getAsString();

    public boolean getAsBoolean();

    public int getAsInt();

    public float getAsFloat();

    public double getAsDouble();

    public long getAsLong();

    public String[] getAsStringArray();

    public boolean[] getAsBooleanArray();

    public byte[] getAsByteArray();

    public int[] getAsIntegerArray();

    public float[] getAsFloatArray();

    public double[] getAsDoubleArray();

    public long[] getAsLongArray();

    public PropertyType getType();

    public long getLength();

    default public boolean isUserReadable() {
        return this.getType() != PropertyType.OBJECT;
    }

    default public boolean isPlainText() {
        return this.getType() == PropertyType.PLAIN;
    }

    public static byte[] unjoinByte(String text) {
        String[] arr = text.split(",");
        byte[] out = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = Byte.parseByte(arr[i]);
        }
        return out;
    }

    public static boolean[] unjoinBoolean(String text) {
        String[] arr = text.split(",");
        boolean[] out = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = Boolean.parseBoolean(arr[i]);
        }
        return out;
    }

    public static int[] unjoinInt(String text) {
        String[] arr = text.split(",");
        int[] out = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = Integer.parseInt(arr[i]);
        }
        return out;
    }

    public static float[] unjoinFloat(String text) {
        String[] arr = text.split(",");
        float[] out = new float[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = Float.parseFloat(arr[i]);
        }
        return out;
    }

    public static double[] unjoinDouble(String text) {
        String[] arr = text.split(",");
        double[] out = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = Double.parseDouble(arr[i]);
        }
        return out;
    }

    public static long[] unjoinLong(String text) {
        String[] arr = text.split(",");
        long[] out = new long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = Long.parseLong(arr[i]);
        }
        return out;
    }

    public static <U> U[] unjoin(String text, Function<String, U> mapper, IntFunction<U[]> construct) {
        return Arrays.stream(text.split(",")).map(mapper).toArray(construct);
    }

    public static <U> U parse(Class<U> returnType, byte[] data) throws PropertyException {
        return returnType.cast(SerializationUtils.deserialize((byte[])data));
    }
}

