/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.foxgenesis.property.ImmutableProperty;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.PropertyMapping;
import net.foxgenesis.property.PropertyType;
import net.foxgenesis.property.UnmodifiablePropertyException;
import org.apache.commons.lang3.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public interface Property<L, M extends PropertyMapping>
extends ImmutableProperty<L, M> {
    default public boolean set(@NotNull L lookup, @NotNull Serializable obj, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        return this.set(lookup, Property.serialize(this.getInfo(), obj), isUserInput);
    }

    default public boolean set(@NotNull L lookup, byte[] data, boolean isUserInput) {
        this.checkUserInput(isUserInput);
        return this.set(lookup, new ByteArrayInputStream(data), isUserInput);
    }

    public boolean set(@NotNull L var1, @NotNull InputStream var2, boolean var3);

    public boolean remove(@NotNull L var1, boolean var2);

    default public boolean isUserModifiable() {
        return this.getInfo().modifiable();
    }

    default public void checkUserInput(boolean user) {
        if (user && !this.isUserModifiable()) {
            throw new UnmodifiablePropertyException("Property " + this.getInfo() + " is not allowed to be modified by user input");
        }
    }

    public static byte[] serialize(@NotNull PropertyInfo info, @NotNull Serializable obj) {
        if (info.type() == PropertyType.PLAIN) {
            if (obj.getClass().isArray()) {
                Serializable[] a = (Serializable[])obj;
                StringBuilder b = new StringBuilder();
                for (int i = 0; i < a.length; ++i) {
                    if (i != 0) {
                        b.append(',');
                    }
                    b.append(Property.serialize(info, a[i]));
                }
                return b.toString().getBytes();
            }
            return obj.toString().getBytes();
        }
        if (info.type() == PropertyType.NUMBER) {
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return ByteBuffer.allocate(4).putInt(i).array();
            }
            if (obj instanceof Long) {
                Long f = (Long)obj;
                return ByteBuffer.allocate(8).putLong(f).array();
            }
            if (obj instanceof Double) {
                Double d = (Double)obj;
                return ByteBuffer.allocate(8).putDouble(d).array();
            }
            if (obj instanceof Float) {
                Float f = (Float)obj;
                return ByteBuffer.allocate(4).putFloat(f.floatValue()).array();
            }
            if (obj instanceof Short) {
                Short s = (Short)obj;
                return ByteBuffer.allocate(2).putShort(s).array();
            }
            if (obj instanceof Boolean) {
                Boolean f = (Boolean)obj;
                return new byte[]{(byte)(f != false ? 1 : 0)};
            }
            if (obj instanceof Byte) {
                Byte b = (Byte)obj;
                return new byte[]{b};
            }
        }
        return SerializationUtils.serialize((Serializable)obj);
    }
}

