/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.foxgenesis.property.PropertyInfo;
import net.foxgenesis.property.PropertyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ImmutableProperty<L, M extends PropertyMapping> {
    @NotNull
    public Optional<M> get(@NotNull L var1);

    @NotNull
    default public Optional<M> getOr(@NotNull L lookup, @NotNull ImmutableProperty<L, M> fallback) {
        Optional<M> r = this.get(lookup);
        if (r.isPresent()) {
            return r;
        }
        return fallback.get(lookup);
    }

    @Nullable
    default public <U> U get(@NotNull L lookup, @NotNull Function<? super M, U> mapper) {
        return this.get(lookup, null, mapper);
    }

    @Nullable
    default public <U> U get(@NotNull L lookup, @Nullable Supplier<U> defaultValue, @NotNull Function<? super M, U> mapper) {
        return this.get(lookup).map(mapper).orElseGet(defaultValue != null ? defaultValue : () -> null);
    }

    public boolean isPresent(@NotNull L var1);

    @NotNull
    public PropertyInfo getInfo();
}

