/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.database;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.foxgenesis.config.KVPFile;
import net.foxgenesis.database.AConnectionProvider;
import net.foxgenesis.util.resource.ModuleResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabase
implements AutoCloseable {
    private final HashMap<String, String> statements = new HashMap();
    private final ModuleResource operationsFile;
    private final ModuleResource setupFile;
    private final String name;
    protected final Logger logger;
    private AConnectionProvider provider;

    public AbstractDatabase(@NotNull String name, @NotNull ModuleResource operationsFile, @NotNull ModuleResource setupFile) {
        this.name = Objects.requireNonNull(name);
        this.operationsFile = Objects.requireNonNull(operationsFile);
        this.setupFile = Objects.requireNonNull(setupFile);
        this.logger = LoggerFactory.getLogger((String)name);
    }

    final synchronized void setup(@NotNull AConnectionProvider provider) throws IOException {
        if (this.provider != null) {
            throw new UnsupportedOperationException("Database is already setup!");
        }
        Objects.requireNonNull(provider);
        this.logger.debug("Setting up {} with provider {}", (Object)this.name, (Object)provider.getName());
        new KVPFile(this.operationsFile).forEach((id, raw) -> {
            if (!this.hasStatementID((String)id)) {
                this.registerStatement((String)id, (String)raw);
            } else {
                this.logger.error("Statement id {} is already registered!", id);
            }
        });
        this.provider = provider;
        this.onReady();
    }

    final synchronized void unload() {
        IOUtil.silentClose((AutoCloseable)this);
        this.provider = null;
    }

    protected abstract void onReady();

    protected Connection openConnection() throws SQLException {
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        if (this.provider != null) {
            return this.provider.openConnection();
        }
        throw new UnsupportedOperationException("Database has not been setup yet!");
    }

    protected void prepareStatement(String id, SQLConsumer<PreparedStatement> func, int ... flags) throws SQLException {
        this.validate(id);
        try (Connection c = this.openConnection();
             PreparedStatement statement = c.prepareStatement(this.getRawStatement(id), flags);){
            func.accept(statement);
        }
    }

    protected void prepareCallable(String id, SQLConsumer<CallableStatement> func) throws SQLException {
        this.validate(id);
        try (Connection c = this.openConnection();
             CallableStatement statement = c.prepareCall(this.getRawStatement(id));){
            func.accept(statement);
        }
    }

    @NotNull
    protected <U> Optional<U> mapStatement(String id, SQLFunction<PreparedStatement, U> func, int ... flags) throws SQLException {
        this.validate(id);
        try (Connection c = this.openConnection();){
            Optional<U> optional;
            block12: {
                PreparedStatement statement = c.prepareStatement(this.getRawStatement(id), flags);
                try {
                    optional = Optional.ofNullable(func.apply(statement));
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return optional;
        }
    }

    @Nullable
    protected <U> Optional<U> mapCallable(String id, SQLFunction<CallableStatement, U> func) throws SQLException {
        this.validate(id);
        try (Connection c = this.openConnection();){
            Optional<U> optional;
            block12: {
                CallableStatement statement = c.prepareCall(this.getRawStatement(id));
                try {
                    optional = Optional.ofNullable(func.apply(statement));
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return optional;
        }
    }

    protected final boolean hasStatementID(String id) {
        return this.statements.containsKey(id);
    }

    protected final String getRawStatement(String id) {
        if (!this.hasStatementID(id)) {
            throw new NoSuchElementException("No statement exists with id " + id);
        }
        return this.statements.get(id);
    }

    private void registerStatement(@NotNull String id, @NotNull String raw) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(raw);
        if (this.statements.containsKey(id)) {
            throw new IllegalArgumentException("id [" + id + "] is already registered!");
        }
        this.logger.debug("Adding statement with id {} [{}]", (Object)id, (Object)raw);
        this.statements.put(id, raw);
    }

    private void validate(String id) {
        if (!this.hasStatementID(id)) {
            throw new NoSuchElementException("No statement exists with id " + id);
        }
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
    }

    final String[] getSetupLines() throws IOException {
        return this.setupFile.readAllLines();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public boolean isReady() {
        return this.provider != null;
    }

    public String getDatabase() {
        return this.provider.getDatabase();
    }

    @FunctionalInterface
    public static interface SQLConsumer<U> {
        public void accept(U var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface SQLFunction<U, V> {
        public V apply(U var1) throws SQLException;
    }
}

