/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AConnectionProvider
implements AutoCloseable {
    protected final Logger logger;
    protected final Properties properties;
    private final String name;
    private final String database;

    public AConnectionProvider(@NotNull String name, @NotNull Properties properties) {
        this.name = Objects.requireNonNull(name);
        this.logger = LoggerFactory.getLogger((String)name);
        this.properties = Objects.requireNonNull(properties);
        String type = properties.getProperty("databaseType", "mysql");
        properties.remove("databaseType");
        String ip = properties.getProperty("ip", "localhost");
        properties.remove("ip");
        String port = properties.getProperty("port", "3306");
        properties.remove("port");
        this.database = properties.getProperty("database", "WatameBot");
        properties.remove("database");
        properties.put("jdbcUrl", "jdbc:%s://%s:%s/%s".formatted(type, ip, port, this.database));
        properties.put("poolName", name);
    }

    @NotNull
    protected abstract Connection openConnection() throws SQLException;

    @NotNull
    protected <U> Optional<U> openAutoClosedConnection(@NotNull ConnectionConsumer<U> consumer) throws SQLException {
        try (Connection conn = this.openConnection();){
            Optional<U> optional = Optional.ofNullable(consumer.applyConnection(conn));
            return optional;
        }
    }

    @NotNull
    protected <U> Optional<U> openAutoClosedConnection(@NotNull ConnectionConsumer<U> consumer, Consumer<Throwable> error) {
        Optional<U> optional;
        block9: {
            Connection conn = this.openConnection();
            try {
                optional = Optional.ofNullable(consumer.applyConnection(conn));
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (error != null) {
                        error.accept(e);
                    }
                    return Optional.empty();
                }
            }
            conn.close();
        }
        return optional;
    }

    public final String getName() {
        return this.name;
    }

    public String getDatabase() {
        return this.database;
    }

    @Override
    public void close() throws Exception {
        this.logger.debug("Shutting down {}", (Object)this.name);
    }

    @FunctionalInterface
    public static interface ConnectionConsumer<U> {
        public U applyConnection(@NotNull Connection var1) throws SQLException;
    }
}

