/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.property;

import java.util.Objects;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.NewsChannel;
import net.dv8tion.jda.api.entities.channel.concrete.StageChannel;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.foxgenesis.watame.property.IGuildPropertyMapping;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class GuildPropertyMapping
implements IGuildPropertyMapping {
    private final String key;
    private final JSONObject data;
    private final Guild guild;

    public <T extends JSONObject> GuildPropertyMapping(String key, T data, Guild guild) {
        this.key = Objects.requireNonNull(key);
        this.data = Objects.requireNonNull(data);
        this.guild = Objects.requireNonNull(guild);
    }

    @Override
    public String getAsString() {
        return this.data.getString(this.key);
    }

    @Override
    public long getAsLong() {
        return this.data.getLong(this.key);
    }

    @Override
    public double getAsDouble() {
        return this.data.getDouble(this.key);
    }

    @Override
    public float getAsFloat() {
        return this.data.getFloat(this.key);
    }

    @Override
    public int getAsInt() {
        return this.data.getInt(this.key);
    }

    @Override
    public boolean getAsBoolean() {
        return this.data.getBoolean(this.key);
    }

    @Override
    @Nullable
    public Category getAsCategory() {
        return this.guild.getCategoryById(this.getAsLong());
    }

    @Override
    @Nullable
    public Channel getAsChannel() {
        return this.guild.getGuildChannelById(this.getAsLong());
    }

    @Override
    @Nullable
    public TextChannel getAsTextChannel() {
        return this.guild.getTextChannelById(this.getAsLong());
    }

    @Override
    @Nullable
    public VoiceChannel getAsVoiceChannel() {
        return this.guild.getVoiceChannelById(this.getAsLong());
    }

    @Override
    @Nullable
    public StageChannel getAsStageChannel() {
        return this.guild.getStageChannelById(this.getAsLong());
    }

    @Override
    @Nullable
    public NewsChannel getAsNewsChannel() {
        return this.guild.getNewsChannelById(this.getAsLong());
    }

    @Override
    @Nullable
    public GuildMessageChannel getAsMessageChannel() {
        return (GuildMessageChannel)this.guild.getChannelById(GuildMessageChannel.class, this.getAsLong());
    }

    @Override
    @Nullable
    public Role getAsRole() {
        return this.guild.getRoleById(this.getAsLong());
    }

    @Override
    @Nullable
    public Member getAsMember() {
        return this.guild.getMemberById(this.getAsLong());
    }

    public int hashCode() {
        return Objects.hash(this.data, this.guild, this.key);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GuildPropertyMapping other = (GuildPropertyMapping)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.guild, other.guild) && Objects.equals(this.data, other.data);
    }

    public String toString() {
        return "GuildPropertyMapping [key=" + this.key + ", data=" + this.data + ", guild=" + this.guild + "]";
    }
}

