/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.property;

import java.util.Objects;
import net.dv8tion.jda.api.entities.Guild;
import net.foxgenesis.config.fields.JSONObjectAdv;
import net.foxgenesis.property.IProperty;
import net.foxgenesis.watame.property.GuildPropertyMapping;
import net.foxgenesis.watame.property.IGuildPropertyMapping;
import net.foxgenesis.watame.sql.IGuildDataProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuildProperty
implements IProperty<String, Guild, IGuildPropertyMapping> {
    private final String key;
    private final IGuildDataProvider database;

    public GuildProperty(String key, IGuildDataProvider database) {
        this.key = Objects.requireNonNull(key, "Key must not be null!");
        this.database = Objects.requireNonNull(database, "Database must not be null!");
    }

    @Override
    @Nullable
    public IGuildPropertyMapping get(@NotNull Guild from) {
        Objects.requireNonNull(from);
        JSONObjectAdv data = this.getData(from);
        if (data == null) {
            throw new IllegalStateException("Data has not been recieved yet!");
        }
        return this.isPresent(from) ? new GuildPropertyMapping(this.key, data, from) : null;
    }

    @Override
    public boolean set(Guild from, @Nullable Object value) {
        if (value != null) {
            this.getData(from).put(this.key, value);
        } else {
            this.getData(from).remove(this.key);
        }
        return true;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isPresent(Guild from) {
        return this.getData(from).has(this.key);
    }

    private JSONObjectAdv getData(Guild from) {
        return this.database.getDataForGuild(from).getConfig();
    }

    public int hashCode() {
        return Objects.hash(this.database, this.key);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GuildProperty other = (GuildProperty)obj;
        return Objects.equals(this.database, other.database) && Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "GuildProperty [key=" + this.key + ", database=" + this.database + "]";
    }
}

