/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.command;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.AutoCompleteQuery;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.foxgenesis.property.IProperty;
import net.foxgenesis.property.IPropertyMapping;
import net.foxgenesis.property.IPropertyProvider;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.property.IGuildPropertyMapping;
import net.foxgenesis.watame.property.IGuildPropertyProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCommand
extends ListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger((String)"Configuration Command");
    private static final String DEFAULT = "Default";
    private static final String CONFIG_VALUE_FORMAT = "%s = `%s`";

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        if (event.isFromGuild()) {
            switch (event.getName()) {
                case "options": {
                    ConfigCommand.handleOptions(event);
                }
            }
        }
    }

    public void onCommandAutoCompleteInteraction(CommandAutoCompleteInteractionEvent event) {
        AutoCompleteQuery option = event.getFocusedOption();
        Guild guild = event.getGuild();
        if (event.isFromGuild() && guild != null && event.getFullCommandName().startsWith("options configuration") && option.getName().equals("key")) {
            IGuildPropertyProvider provider = WatameBot.INSTANCE.getPropertyProvider();
            event.replyChoices(provider.keySet().stream().filter(key -> provider.getProperty(key).isEditable()).filter(key -> key.contains(option.getValue().toLowerCase())).map(key -> new Command.Choice(key, key)).toList()).queue();
        }
    }

    private static void handleOptions(SlashCommandInteractionEvent event) {
        String group;
        switch (group = Objects.requireNonNull(event.getSubcommandGroup())) {
            case "configuration": {
                ConfigCommand.handleConfiguration(event);
            }
        }
    }

    private static void handleConfiguration(SlashCommandInteractionEvent event) {
        IGuildPropertyProvider provider = WatameBot.INSTANCE.getPropertyProvider();
        String sub = Objects.requireNonNull(event.getSubcommandName());
        InteractionHook hook = event.getHook();
        int tmp = sub.indexOf(45);
        if (tmp != -1) {
            sub = sub.substring(0, tmp);
        }
        switch (sub) {
            case "get": {
                ConfigCommand.getConfigurationSetting(event, provider, hook);
                break;
            }
            case "set": {
                ConfigCommand.setConfigurationSetting(event, provider, hook);
                break;
            }
            case "remove": {
                ConfigCommand.removeConfigurationSetting(event, provider, hook);
                break;
            }
            case "list": {
                ConfigCommand.listAllConfigurationSettings(event, provider, hook);
            }
        }
    }

    private static void getConfigurationSetting(SlashCommandInteractionEvent event, IPropertyProvider<String, Guild, IGuildPropertyMapping> provider, InteractionHook hook) {
        event.deferReply(true).queue();
        ConfigCommand.ensureKey((String)event.getOption("key", OptionMapping::getAsString), provider, hook, (key, property) -> {
            User user = event.getUser();
            logger.info("{}[{}] Checked configuration for {}", new Object[]{user.getName(), user.getId(), key});
            hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(2201331, "\u2699 Configuration \u2699", CONFIG_VALUE_FORMAT.formatted(key, provider.getProperty(Objects.requireNonNull(key)).get(Objects.requireNonNull(event.getGuild()), DEFAULT, IPropertyMapping::getAsString)))}).queue();
        });
    }

    private static void setConfigurationSetting(SlashCommandInteractionEvent event, IPropertyProvider<String, Guild, IGuildPropertyMapping> provider, InteractionHook hook) {
        event.deferReply(true).queue();
        ConfigCommand.ensureKey((String)event.getOption("key", OptionMapping::getAsString), provider, hook, (key, property) -> ConfigCommand.ensureValue(event.getOptions(), hook, value -> {
            if (property.isEditable()) {
                Member member = Objects.requireNonNull(event.getMember());
                Guild guild = member.getGuild();
                String old = property.get(guild, DEFAULT, IPropertyMapping::getAsString);
                if (property.set(guild, value, true)) {
                    logger.info("{}[{}] Put {} -> {} into the configuration", new Object[]{member.getUser().getName(), member.getUser().getId(), key, value});
                    hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(5025616, "Updated", "Set `%s` to `%s`".formatted(key, value))}).queue();
                    ConfigCommand.logChange(member, key, old, value);
                } else {
                    ConfigCommand.unknownError(hook);
                }
            } else {
                hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Property is not user editable")}).queue();
            }
        }));
    }

    private static void removeConfigurationSetting(SlashCommandInteractionEvent event, IPropertyProvider<String, Guild, IGuildPropertyMapping> provider, InteractionHook hook) {
        event.deferReply(true).queue();
        ConfigCommand.ensureKey((String)event.getOption("key", OptionMapping::getAsString), provider, hook, (key, property) -> {
            if (property.isEditable()) {
                Member member = Objects.requireNonNull(event.getMember());
                Guild guild = member.getGuild();
                String old = property.get(guild, DEFAULT, IPropertyMapping::getAsString);
                if (property.set(guild, null, true)) {
                    logger.info("{}[{}] Removed {} from the configuration", new Object[]{member.getUser().getName(), member.getUser().getId(), key});
                    hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(5025616, "Updated", "Set `%s` to `%s`".formatted(key, DEFAULT))}).queue();
                    ConfigCommand.logChange(member, key, old, DEFAULT);
                } else {
                    ConfigCommand.unknownError(hook);
                }
            } else {
                hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Property is not user editable")}).queue();
            }
        });
    }

    private static void listAllConfigurationSettings(SlashCommandInteractionEvent event, IPropertyProvider<String, Guild, IGuildPropertyMapping> provider, InteractionHook hook) {
        event.deferReply(true).queue();
        Guild guild = event.getGuild();
        if (guild != null) {
            HashMap map = new HashMap();
            provider.keySet().stream().forEach(key -> map.put(key, provider.getProperty((String)key).get(guild, DEFAULT, IPropertyMapping::getAsString)));
            StringBuilder builder = new StringBuilder();
            map.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).forEachOrdered(entry -> builder.append(" \u2022 %s = `%s`\n".formatted(entry.getKey(), entry.getValue())));
            hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(2201331, "\u2699 Configuration List \u2699", builder.toString())}).queue();
        } else {
            ConfigCommand.unknownError(hook);
        }
    }

    private static void ensureKey(String key, IPropertyProvider<String, Guild, IGuildPropertyMapping> provider, InteractionHook hook, @NotNull BiConsumer<String, IProperty<String, Guild, IGuildPropertyMapping>> consumer) {
        if (key != null) {
            if (provider.isPropertyPresent(key)) {
                consumer.accept(key, provider.getProperty(key));
            } else {
                hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Unkown Key")}).queue();
            }
        } else {
            hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Please enter a key")}).queue();
        }
    }

    private static void ensureValue(@NotNull List<OptionMapping> mappings, @NotNull InteractionHook hook, @NotNull Consumer<String> consumer) {
        for (OptionMapping m : mappings) {
            if (m.getName().equals("key")) continue;
            consumer.accept(m.getAsString());
            return;
        }
        hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Unable to get value field")}).queue();
    }

    private static MessageEmbed response(int color, @NotNull String title, @Nullable String desc) {
        return new EmbedBuilder().setColor(color).setTitle(title).setDescription((CharSequence)desc).build();
    }

    private static void logChange(Member user, String key, String oldValue, String value) {
        GuildMessageChannel channel = WatameBot.INSTANCE.getGuildLoggingChannel().get(user.getGuild(), IGuildPropertyMapping::getAsMessageChannel);
        if (channel != null) {
            ((MessageCreateAction)((MessageCreateAction)channel.sendMessageEmbeds(new EmbedBuilder().setColor(16761095).setTitle("Configuration Change").setDescription((CharSequence)"Plugin configuration has been updated").addField("Type", value == null ? "Remove" : "Update", true).addField("User", user.getAsMention(), true).addField("Key", key, true).addField("Old Value", oldValue, true).addField("Value", value != null ? value : "N/A", true).build(), new MessageEmbed[0]).addCheck(() -> ((GuildMessageChannel)channel).canTalk())).addCheck(() -> user.hasPermission((GuildChannel)channel, new Permission[]{Permission.MESSAGE_EMBED_LINKS}))).queue();
        }
    }

    private static void unknownError(InteractionHook hook) {
        hook.editOriginalEmbeds(new MessageEmbed[]{ConfigCommand.response(16007990, "Error", "Something went wrong. Please try again later")}).queue();
    }
}

