/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import org.slf4j.LoggerFactory;

public enum ExitCode {
    INSTANCE_ALREADY_RUNNING(1),
    SETUP_ERROR(2),
    RESOURCE_IO_ERROR(5),
    NO_TOKEN(12),
    INVALID_TOKEN(13),
    JDA_BUILD_FAIL(20),
    DATABASE_NOT_CONNECTED(30),
    DATABASE_INVALID_SETUP_FILE(31),
    DATABASE_SETUP_ERROR(32),
    DATABASE_ACCESS_ERROR(33),
    DATABASE_STATEMENT_MISSING(34),
    DATABASE_STATEMENT_ERROR(35);

    private final int statusCode;

    private ExitCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Integer getCode() {
        return this.statusCode;
    }

    public void programExit(String exitMessage, Exception thrown) throws Exception {
        LoggerFactory.getLogger((String)"global").error(exitMessage == null ? this.name() : exitMessage, (Throwable)thrown);
        this.programExit();
        if (thrown != null) {
            throw thrown;
        }
    }

    public void programExit(Exception thrown) throws Exception {
        this.programExit(null, thrown);
    }

    public void programExit(String exitMessage) throws Exception {
        this.programExit(exitMessage, null);
    }

    public void programExit() throws Exception {
        System.exit(this.getCode());
    }
}

