/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class ModuleResource {
    private final Module module;
    private final String path;

    public ModuleResource(@NotNull Module module, @NotNull String resource) {
        this.module = Objects.requireNonNull(module);
        this.path = Objects.requireNonNull(resource);
    }

    public ModuleResource(@NotNull String moduleName, @NotNull String resourcePath) throws NoSuchElementException {
        this(ModuleLayer.boot().findModule(moduleName).orElseThrow(() -> new NoSuchElementException("No module found '" + moduleName + "'")), resourcePath);
    }

    public InputStream openStream() throws IOException {
        return this.module.getResourceAsStream(this.path);
    }

    public void writeToFile(@NotNull Path path, CopyOption ... options) throws IOException {
        try (InputStream in = this.openStream();){
            Files.copy(in, path, options);
        }
    }

    public String readToString() throws IOException {
        try (InputStream in = this.openStream();){
            String string = new String(in.readAllBytes());
            return string;
        }
    }

    public String[] readAllLines() throws IOException {
        return this.readToString().split("(\\r\\n|\\r|\\n)");
    }

    public Properties asProperties() throws IOException {
        Properties properties = new Properties();
        try (InputStream in = this.openStream();){
            properties.load(in);
        }
        return properties;
    }

    public Module getModule() {
        return this.module;
    }

    public String getResourcePath() {
        return this.path;
    }

    public String toString() {
        return this.module.getName() + ":" + this.path;
    }
}

