/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    public static final Pattern PATTERN_URL = Pattern.compile("\\b((http|https|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", 2);
    public static final Pattern PATTERN_URL_WITH_GROUPING = Pattern.compile("\\b(?<protocol>http[s]?|ftp|file)://(?<domain>[-a-zA-Z0-9+&@#%?=~_|!:,.;]*[-a-zA-Z0-9+&@#%=~_|])(?<path>\\S*(?<file>(?<=/)\\S*))?", 2);
    public static final Predicate<String> CONTAINS_URL = PATTERN_URL.asPredicate();
    public static final Predicate<String> IS_URL = PATTERN_URL.asMatchPredicate();

    @NotNull
    public static Stream<MatchResult> findURLWithGroups(@NotNull String str) {
        return PATTERN_URL_WITH_GROUPING.matcher(str).results();
    }

    @NotNull
    public static Stream<URL> findURLs(@NotNull String str) {
        return StringUtils.findURLs(str, null);
    }

    @NotNull
    public static Stream<URL> findURLs(@NotNull String str, @Nullable Consumer<Exception> errorHandler) {
        Stream<@Nullable URL> stream = PATTERN_URL.matcher(str).results().map(result -> result.group()).filter(s -> !s.isBlank()).map(t -> {
            try {
                return new URL((String)t);
            }
            catch (MalformedURLException e) {
                if (errorHandler != null) {
                    errorHandler.accept(e);
                }
                return null;
            }
        });
        return stream.filter(url -> url != null);
    }

    public static String limit(String str, int length) {
        return str != null && str.length() > length ? str.substring(0, length) : str;
    }
}

