/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import net.foxgenesis.util.resource.ModuleResource;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderProperties;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.INIBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtils.class);

    public static List<String> linesFromResource(URL path) throws IOException {
        logger.trace("Attempting to read resource: " + path);
        ArrayList<String> list = new ArrayList<String>();
        try (InputStreamReader isr = new InputStreamReader(path.openStream());){
            ArrayList<String> arrayList;
            try (BufferedReader reader = new BufferedReader(isr);){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    list.add(line);
                }
                arrayList = list;
            }
            return arrayList;
        }
    }

    public static Properties getProperties(URL path) throws IOException {
        logger.trace("Attempting to read resource: " + path);
        Properties properties = new Properties();
        try (InputStream in = path.openStream();){
            properties.load(in);
        }
        return properties;
    }

    public static Properties getProperties(Path path, ModuleResource defaults) throws IOException {
        if (Files.notExists(path, LinkOption.NOFOLLOW_LINKS)) {
            if (defaults != null) {
                defaults.writeToFile(path, new CopyOption[0]);
                return ResourceUtils.getProperties(path, defaults);
            }
            throw new FileNotFoundException("The specified file was not found: " + path);
        }
        Properties properties = new Properties();
        try (InputStream in = Files.newInputStream(path, StandardOpenOption.READ);){
            properties.load(in);
        }
        return properties;
    }

    public static PropertiesConfiguration loadProperties(ModuleResource defaults, Path dir, String output) throws IOException, ConfigurationException {
        Path outputPath = ResourceUtils.writeDefaults(defaults, dir, output);
        PropertiesBuilderParameters propParams = new Parameters().properties();
        propParams.setBasePath(dir.toString());
        propParams.setPath(outputPath.toString());
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        builder.configure(new BuilderParameters[]{propParams});
        return (PropertiesConfiguration)builder.getConfiguration();
    }

    public static INIConfiguration loadINI(ModuleResource defaults, Path dir, String output) throws IOException, ConfigurationException {
        return ResourceUtils.loadConfig(defaults, dir, output, INIConfiguration.class, out -> (FileBasedBuilderProperties)((INIBuilderParameters)new Parameters().ini().setBasePath(dir.toString())).setPath(out));
    }

    private static <T extends FileBasedConfiguration> T loadConfig(ModuleResource defaults, Path dir, String output, Class<T> configurationClass, Function<String, ? extends FileBasedBuilderProperties<?>> paramBuilder) throws IOException, ConfigurationException {
        Path outputPath = ResourceUtils.writeDefaults(defaults, dir, output);
        return (T)((FileBasedConfiguration)new FileBasedConfigurationBuilder(configurationClass).configure(new BuilderParameters[]{(BuilderParameters)paramBuilder.apply(outputPath.toAbsolutePath().toString())}).getConfiguration());
    }

    private static Path writeDefaults(ModuleResource defaults, Path dir, String output) throws IOException {
        if (Files.notExists(dir, LinkOption.NOFOLLOW_LINKS)) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Path outputPath = dir.resolve(output);
        if (Files.notExists(outputPath, LinkOption.NOFOLLOW_LINKS)) {
            defaults.writeToFile(outputPath, new CopyOption[0]);
        } else {
            if (Files.isDirectory(outputPath, LinkOption.NOFOLLOW_LINKS)) {
                throw new IllegalArgumentException(outputPath.toString() + " is not a regular file!");
            }
            if (!Files.isReadable(outputPath)) {
                throw new SecurityException("Unable to read " + outputPath.toString() + ". Missing permissions!");
            }
        }
        return outputPath;
    }

    public static String toString(@NotNull InputStream input) throws IOException {
        try (InputStream inputStream = input;){
            String string = new String(input.readAllBytes());
            return string;
        }
    }

    public static String[] toSplitString(@NotNull InputStream input) throws IOException {
        return ResourceUtils.toString(input).split("(\\r\\n|\\r|\\n)");
    }
}

