/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property2.impl;

import java.util.Objects;
import java.util.Optional;
import net.foxgenesis.property2.Property;
import net.foxgenesis.property2.PropertyResolver;
import net.foxgenesis.property2.PropertyType;
import org.jetbrains.annotations.NotNull;

public class PropertyImpl<L, R extends PropertyResolver<L>>
implements Property<L> {
    protected static final String DELIMETER = ",";
    @NotNull
    protected final String key;
    @NotNull
    protected final R resolver;
    @NotNull
    protected PropertyType type = PropertyType.STRING;

    public PropertyImpl(@NotNull String key, @NotNull R resolver) {
        this.key = Objects.requireNonNull(key);
        this.resolver = (PropertyResolver)Objects.requireNonNull(resolver);
    }

    @Override
    @NotNull
    public Optional<String> getString(L lookup) {
        return this.resolver.getString(lookup, this.key);
    }

    @Override
    @NotNull
    public Optional<Boolean> getBoolean(L lookup) {
        return this.resolver.getBoolean(lookup, this.key);
    }

    @Override
    @NotNull
    public Optional<Integer> getInt(L lookup) {
        return this.resolver.getInt(lookup, this.key);
    }

    @Override
    @NotNull
    public Optional<Float> getFloat(L lookup) {
        return this.resolver.getFloat(lookup, this.key);
    }

    @Override
    @NotNull
    public Optional<Double> getDouble(L lookup) {
        return this.resolver.getDouble(lookup, this.key);
    }

    @Override
    @NotNull
    public Optional<Long> getLong(L lookup) {
        return this.resolver.getLong(lookup, this.key);
    }

    @Override
    @NotNull
    public Optional<String[]> getStringArray(L lookup) {
        return this.resolver.getStringArray(lookup, this.key, DELIMETER);
    }

    @Override
    @NotNull
    public Optional<Boolean[]> getBooleanArray(L lookup) {
        return this.resolver.getBooleanArray(lookup, this.key, DELIMETER);
    }

    @Override
    @NotNull
    public Optional<Integer[]> getIntArray(L lookup) {
        return this.resolver.getIntArray(lookup, this.key, DELIMETER);
    }

    @Override
    @NotNull
    public Optional<Float[]> getFloatArray(L lookup) {
        return this.resolver.getFloatArray(lookup, this.key, DELIMETER);
    }

    @Override
    @NotNull
    public Optional<Double[]> getDoubleArray(L lookup) {
        return this.resolver.getDoubleArray(lookup, this.key, DELIMETER);
    }

    @Override
    @NotNull
    public Optional<Long[]> getLongArray(L lookup) {
        return this.resolver.getLongArray(lookup, this.key, DELIMETER);
    }

    @Override
    public boolean putString(@NotNull L lookup, @NotNull String value) {
        return this.resolver.putString(lookup, this.key, value);
    }

    @Override
    public boolean putBoolean(@NotNull L lookup, boolean value) {
        return this.resolver.putBoolean(lookup, this.key, value);
    }

    @Override
    public boolean putInt(@NotNull L lookup, int value) {
        return this.resolver.putInt(lookup, this.key, value);
    }

    @Override
    public boolean putFloat(@NotNull L lookup, float value) {
        return this.resolver.putFloat(lookup, this.key, value);
    }

    @Override
    public boolean putDouble(@NotNull L lookup, double value) {
        return this.resolver.putDouble(lookup, this.key, value);
    }

    @Override
    public boolean putLong(@NotNull L lookup, long value) {
        return this.resolver.putLong(lookup, this.key, value);
    }

    @Override
    public boolean putStringArray(@NotNull L lookup, @NotNull String[] arr) {
        return this.resolver.putStringArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putBooleanArray(@NotNull L lookup, boolean[] arr) {
        return this.resolver.putBooleanArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putIntArray(@NotNull L lookup, int[] arr) {
        return this.resolver.putIntArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putFloatArray(@NotNull L lookup, float[] arr) {
        return this.resolver.putFloatArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putDoubleArray(@NotNull L lookup, double[] arr) {
        return this.resolver.putDoubleArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putLongArray(@NotNull L lookup, long[] arr) {
        return this.resolver.putLongArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean remove(@NotNull L lookup) {
        return this.resolver.remove(lookup, this.key);
    }

    @Override
    @NotNull
    public PropertyType getType(@NotNull L lookup) {
        return PropertyType.STRING;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public String toString() {
        return "Property[key = " + this.key + ", type = " + this.type + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.resolver, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.resolver, other.resolver) && this.type == other.type;
    }
}

