/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property2.impl;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.foxgenesis.property2.PropertyType;
import net.foxgenesis.property2.async.AsyncProperty;
import net.foxgenesis.property2.async.AsyncPropertyResolver;
import net.foxgenesis.property2.impl.PropertyImpl;
import org.jetbrains.annotations.NotNull;

public class AsyncPropertyImpl<L>
extends PropertyImpl<L, AsyncPropertyResolver<L>>
implements AsyncProperty<L> {
    public AsyncPropertyImpl(@NotNull String key, @NotNull AsyncPropertyResolver<L> resolver) {
        super(key, resolver);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<String>> getStringAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getStringAsync(lookup, this.key);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Boolean>> getBooleanAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getBooleanAsync(lookup, this.key);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Integer>> getIntAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getIntAsync(lookup, this.key);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Float>> getFloatAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getFloatAsync(lookup, this.key);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Double>> getDoubleAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getDoubleAsync(lookup, this.key);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Long>> getLongAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getLongAsync(lookup, this.key);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<String[]>> getStringArrayAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getStringArrayAsync(lookup, this.key, ",");
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Boolean[]>> getBooleanArrayAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getBooleanArrayAsync(lookup, this.key, ",");
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Integer[]>> getIntArrayAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getIntArrayAsync(lookup, this.key, ",");
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Float[]>> getFloatArrayAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getFloatArrayAsync(lookup, this.key, ",");
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Double[]>> getDoubleArrayAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getDoubleArrayAsync(lookup, this.key, ",");
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Long[]>> getLongArrayAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getLongArrayAsync(lookup, this.key, ",");
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putStringAsync(@NotNull L lookup, String value) {
        return ((AsyncPropertyResolver)this.resolver).putStringAsync(lookup, value, value);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putBooleanAsync(@NotNull L lookup, boolean value) {
        return ((AsyncPropertyResolver)this.resolver).putBooleanAsync(lookup, this.key, value);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putIntAsync(@NotNull L lookup, int value) {
        return ((AsyncPropertyResolver)this.resolver).putIntAsync(lookup, this.key, value);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putFloatAsync(@NotNull L lookup, float value) {
        return ((AsyncPropertyResolver)this.resolver).putFloatAsync(lookup, this.key, value);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putDoubleAsync(@NotNull L lookup, double value) {
        return ((AsyncPropertyResolver)this.resolver).putDoubleAsync(lookup, this.key, value);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putLongAsync(@NotNull L lookup, long value) {
        return ((AsyncPropertyResolver)this.resolver).putLongAsync(lookup, this.key, value);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putStringArrayAsync(@NotNull L lookup, @NotNull String[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putStringArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putBooleanArrayAsync(@NotNull L lookup, boolean[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putBooleanArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putIntArrayAsync(@NotNull L lookup, int[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putIntArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putFloatArrayAsync(@NotNull L lookup, float[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putFloatArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putDoubleArrayAsync(@NotNull L lookup, double[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putDoubleArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putLongArrayAsync(@NotNull L lookup, long[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putLongArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> removeAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).removeAsync(lookup, this.key);
    }

    @Override
    @NotNull
    public CompletableFuture<PropertyType> getTypeAsync(@NotNull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).typeOfAsync(lookup, this.key);
    }
}

