/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property2.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.foxgenesis.property2.Property;
import net.foxgenesis.property2.PropertyResolver;
import net.foxgenesis.property2.PropertyType;
import org.jetbrains.annotations.NotNull;

public abstract class APropertyProvider<L, T extends Property<L>, R extends PropertyResolver<L>> {
    protected final R resolver;
    protected final HashMap<String, T> properties = new HashMap();

    public APropertyProvider(@NotNull R resolver) {
        this.resolver = (PropertyResolver)Objects.requireNonNull(resolver);
    }

    @NotNull
    public abstract T getProperty(@NotNull String var1);

    public boolean isPropertyPresent(@NotNull String key) {
        return this.properties.containsKey(key);
    }

    @NotNull
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @NotNull
    public Stream<T> typesOf(@NotNull L lookup, @NotNull PropertyType type) {
        return Collections.unmodifiableCollection(this.properties.values()).stream().filter(p -> p.getType(lookup).equals((Object)type));
    }
}

