/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.database;

import java.sql.ResultSet;
import java.util.Objects;
import java.util.Optional;
import net.foxgenesis.property.database.ConfigurationDatabase;
import org.jetbrains.annotations.NotNull;

public class SQLConfigurationDatabase
extends ConfigurationDatabase<Long> {
    public SQLConfigurationDatabase(String name, String database, String table) {
        super(name, database, table);
    }

    @Override
    protected Optional<String> getInternal(@NotNull Long lookup, @NotNull String key) {
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database is not ready yet!");
        }
        Objects.requireNonNull(lookup);
        Objects.requireNonNull(key);
        return this.mapStatement("property_get", statement -> {
            statement.setLong(1, lookup);
            statement.setString(2, key);
            try (ResultSet result = statement.executeQuery();){
                if (result.next()) {
                    String string = result.getString("property");
                    return string;
                }
                String string = null;
                return string;
            }
        }, err -> this.logger.error("Error while getting internal property", err));
    }

    @Override
    protected boolean putInternal(@NotNull Long lookup, @NotNull String key, @NotNull String value) {
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database is not ready yet!");
        }
        Objects.requireNonNull(lookup);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.mapStatement("property_insert", statement -> {
            statement.setLong(1, lookup);
            statement.setString(2, key);
            statement.setString(3, value);
            return statement.executeUpdate() > 0;
        }, err -> this.logger.error("Error while putting internal property", err)).orElse(false);
    }

    @Override
    protected boolean removeInternal(@NotNull Long lookup, @NotNull String key) {
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database is not ready yet!");
        }
        Objects.requireNonNull(key);
        return this.mapStatement("property_delete", statement -> {
            statement.setLong(1, lookup);
            statement.setString(2, key);
            return statement.executeUpdate() > 0;
        }, err -> this.logger.error("Error while removing internal property", err)).orElse(false);
    }

    @Override
    protected void onReady() {
    }

    @Override
    public synchronized void close() {
    }
}

