/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.database;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.foxgenesis.database.AbstractDatabase;
import net.foxgenesis.property2.PropertyType;
import net.foxgenesis.property2.async.AsyncPropertyResolver;
import net.foxgenesis.util.resource.FormattedModuleResource;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationDatabase<L>
extends AbstractDatabase
implements AsyncPropertyResolver<L> {
    private static final ExecutorService COMMON_POOL = ForkJoinPool.commonPool();
    private final ExecutorService defaultExecutor;
    private final String database;
    private final String table;

    public ConfigurationDatabase(@NotNull String name, @NotNull String database, @NotNull String table, @Nullable ExecutorService service) {
        super(name, new FormattedModuleResource("watamebot", "/META-INF/configDatabase/statements.kvp", Map.of("database", database, "table", table)), new FormattedModuleResource("watamebot", "/META-INF/configDatabase/setup.sql", Map.of("database", database, "table", table)));
        this.database = Objects.requireNonNull(database);
        this.table = Objects.requireNonNull(table);
        this.defaultExecutor = Objects.requireNonNullElse(service, COMMON_POOL);
    }

    public ConfigurationDatabase(@NotNull String name, @NotNull String database, @NotNull String table) {
        this(name, database, table, null);
    }

    @NotNull
    protected CompletableFuture<Boolean> removeInternalAsync(@NotNull L lookup, @NotNull String key, @Nullable ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> this.removeInternal(lookup, key), this.screenExecutor(service));
    }

    @NotNull
    protected CompletableFuture<Boolean> putInternalAsync(@NotNull L lookup, @NotNull String key, @NotNull String value, @Nullable ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> this.putInternal(lookup, key, value), this.screenExecutor(service));
    }

    @NotNull
    private CompletableFuture<Boolean> putInternalAsync(@NotNull L lookup, @NotNull String key, @NotNull Supplier<String> value, @Nullable ExecutorService service) {
        return CompletableFuture.supplyAsync(value, this.screenExecutor(service)).thenCompose(v -> this.putInternalAsync(lookup, key, (String)v, service));
    }

    @NotNull
    protected CompletableFuture<Optional<String>> getInternalAsync(@NotNull L lookup, @NotNull String key, @Nullable ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> this.getInternal(lookup, key), this.screenExecutor(service));
    }

    @NotNull
    protected <T> CompletableFuture<Boolean> putArrayInternalAsync(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, @NotNull T[] arr, @Nullable ExecutorService service) {
        if (arr.length == 0) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Array must not be empty!"));
        }
        return this.putInternalAsync(lookup, key, () -> Arrays.stream(arr).map(Object::toString).reduce((a, b) -> a.toString() + delimeter + b.toString()).get(), service);
    }

    @NotNull
    protected <T> CompletableFuture<Optional<T[]>> getArrayInternalAsync(@NotNull L lookup, @NotNull String key, @NotNull String regex, @NotNull Function<String, T> map, @NotNull IntFunction<T[]> arr, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApplyAsync(o -> o.map(str -> Arrays.stream(str.split(regex)).map(map).toArray(arr)), (Executor)this.screenExecutor(service));
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<String>> getStringAsync(@NotNull L lookup, @NotNull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Boolean>> getBooleanAsync(@NotNull L lookup, @NotNull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Boolean::parseBoolean));
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Integer>> getIntAsync(@NotNull L lookup, @NotNull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Integer::parseInt));
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Float>> getFloatAsync(@NotNull L lookup, @NotNull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Float::parseFloat));
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Double>> getDoubleAsync(@NotNull L lookup, @NotNull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Double::parseDouble));
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Long>> getLongAsync(@NotNull L lookup, @NotNull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Long::parseLong));
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<String[]>> getStringArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Function.identity(), String[]::new, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Boolean[]>> getBooleanArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Boolean::parseBoolean, Boolean[]::new, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Integer[]>> getIntArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Integer::parseInt, Integer[]::new, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Float[]>> getFloatArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Float::parseFloat, Float[]::new, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Double[]>> getDoubleArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Double::parseDouble, Double[]::new, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Long[]>> getLongArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Long::parseLong, Long[]::new, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putStringAsync(@NotNull L lookup, @NotNull String key, @NotNull String value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, value, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putBooleanAsync(@NotNull L lookup, @NotNull String key, boolean value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putIntAsync(@NotNull L lookup, @NotNull String key, int value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putFloatAsync(@NotNull L lookup, @NotNull String key, float value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putDoubleAsync(@NotNull L lookup, @NotNull String key, double value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putLongAsync(@NotNull L lookup, @NotNull String key, long value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putStringArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, @NotNull String[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, arr, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putBooleanArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, boolean[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((boolean[])arr), service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putIntArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, int[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((int[])arr), service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putFloatArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, float[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((float[])arr), service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putDoubleArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, double[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((double[])arr), service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> putLongArrayAsync(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, long[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((long[])arr), service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> removeAsync(@NotNull L lookup, @NotNull String key, @Nullable ExecutorService service) {
        return this.removeInternalAsync(lookup, key, service);
    }

    @Override
    @NotNull
    public CompletableFuture<PropertyType> typeOfAsync(L lookup, String key, ExecutorService service) {
        return CompletableFuture.completedFuture(PropertyType.STRING);
    }

    protected abstract boolean removeInternal(@NotNull L var1, @NotNull String var2);

    protected abstract boolean putInternal(@NotNull L var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    protected abstract Optional<String> getInternal(@NotNull L var1, @NotNull String var2);

    protected <T> boolean putArrayInternal(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, @NotNull T[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array must not be empty!");
        }
        return this.putInternal(lookup, key, Arrays.stream(arr).map(Object::toString).reduce((a, b) -> a.toString() + delimeter + b.toString()).get());
    }

    @NotNull
    protected <T> Optional<T[]> getArrayInternal(@NotNull L lookup, @NotNull String key, @NotNull String regex, @NotNull Function<String, T> map, @NotNull IntFunction<T[]> arr) {
        return this.getInternal(lookup, key).map(str -> Arrays.stream(str.split(regex)).map(map).toArray(arr));
    }

    @Override
    @NotNull
    public Optional<String> getString(L lookup, String key) {
        return this.getInternal(lookup, key);
    }

    @Override
    @NotNull
    public Optional<Boolean> getBoolean(L lookup, String key) {
        return this.getInternal(lookup, key).map(Boolean::parseBoolean);
    }

    @Override
    @NotNull
    public Optional<Integer> getInt(@NotNull L lookup, @NotNull String key) {
        return this.getInternal(lookup, key).map(Integer::parseInt);
    }

    @Override
    @NotNull
    public Optional<Float> getFloat(@NotNull L lookup, @NotNull String key) {
        return this.getInternal(lookup, key).map(Float::parseFloat);
    }

    @Override
    @NotNull
    public Optional<Double> getDouble(@NotNull L lookup, @NotNull String key) {
        return this.getInternal(lookup, key).map(Double::parseDouble);
    }

    @Override
    @NotNull
    public Optional<Long> getLong(@NotNull L lookup, @NotNull String key) {
        return this.getInternal(lookup, key).map(Long::parseLong);
    }

    @Override
    @NotNull
    public Optional<String[]> getStringArray(@NotNull L lookup, @NotNull String key, @NotNull String regex) {
        return this.getArrayInternal(lookup, key, regex, Function.identity(), String[]::new);
    }

    @Override
    @NotNull
    public Optional<Boolean[]> getBooleanArray(@NotNull L lookup, @NotNull String key, @NotNull String regex) {
        return this.getArrayInternal(lookup, key, regex, Boolean::parseBoolean, Boolean[]::new);
    }

    @Override
    @NotNull
    public Optional<Integer[]> getIntArray(@NotNull L lookup, @NotNull String key, @NotNull String regex) {
        return this.getArrayInternal(lookup, key, regex, Integer::parseInt, Integer[]::new);
    }

    @Override
    @NotNull
    public Optional<Float[]> getFloatArray(@NotNull L lookup, @NotNull String key, @NotNull String regex) {
        return this.getArrayInternal(lookup, key, regex, Float::parseFloat, Float[]::new);
    }

    @Override
    @NotNull
    public Optional<Double[]> getDoubleArray(@NotNull L lookup, @NotNull String key, @NotNull String regex) {
        return this.getArrayInternal(lookup, key, regex, Double::parseDouble, Double[]::new);
    }

    @Override
    @NotNull
    public Optional<Long[]> getLongArray(@NotNull L lookup, @NotNull String key, @NotNull String regex) {
        return this.getArrayInternal(lookup, key, regex, Long::parseLong, Long[]::new);
    }

    @Override
    public boolean putString(@NotNull L lookup, @NotNull String key, @NotNull String value) {
        return this.putInternal(lookup, key, value);
    }

    @Override
    public boolean putBoolean(@NotNull L lookup, @NotNull String key, boolean value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putInt(@NotNull L lookup, @NotNull String key, int value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putFloat(@NotNull L lookup, @NotNull String key, float value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putDouble(@NotNull L lookup, @NotNull String key, double value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putLong(@NotNull L lookup, @NotNull String key, long value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putStringArray(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, @NotNull String[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, arr);
    }

    @Override
    public boolean putBooleanArray(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, boolean[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((boolean[])arr));
    }

    @Override
    public boolean putIntArray(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, int[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((int[])arr));
    }

    @Override
    public boolean putFloatArray(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, float[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((float[])arr));
    }

    @Override
    public boolean putDoubleArray(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, double[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((double[])arr));
    }

    @Override
    public boolean putLongArray(@NotNull L lookup, @NotNull String key, @NotNull String delimeter, long[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((long[])arr));
    }

    @Override
    public boolean remove(@NotNull L lookup, @NotNull String key) {
        return this.removeInternal(lookup, key);
    }

    @Override
    @NotNull
    public PropertyType typeOf(L lookup, String key) {
        return PropertyType.STRING;
    }

    @NotNull
    public String getDatabase() {
        return this.database;
    }

    @NotNull
    public String getTable() {
        return this.table;
    }

    @NotNull
    private ExecutorService screenExecutor(@Nullable ExecutorService service) {
        return service != null ? service : this.defaultExecutor;
    }
}

