/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.database;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.foxgenesis.property.CachedObject;
import net.foxgenesis.property.database.SQLConfigurationDatabase;
import org.jetbrains.annotations.NotNull;

public class CachedSQLConfigurationDatabase
extends SQLConfigurationDatabase {
    private final ConcurrentHashMap<String, CachedObject<String>> cache = new ConcurrentHashMap();
    private final long cacheTimeMilli;

    public CachedSQLConfigurationDatabase(@NotNull String name, @NotNull String database, @NotNull String table, long cacheTimeMilli) {
        super(name, database, table);
        this.cacheTimeMilli = cacheTimeMilli;
    }

    @Override
    protected boolean putInternal(@NotNull Long lookup, @NotNull String key, @NotNull String value) {
        this.getCached(lookup, key).set(value);
        return super.putInternal(lookup, key, value);
    }

    @Override
    protected Optional<String> getInternal(@NotNull Long lookup, @NotNull String key) {
        return Optional.ofNullable(this.getCached(lookup, key).get());
    }

    @NotNull
    private CachedObject<String> getCached(long lookup, @NotNull String key) {
        return this.cache.computeIfAbsent(lookup + ":" + key, k -> new CachedObject<String>(() -> super.getInternal(lookup, key).orElse(null), this.cacheTimeMilli));
    }

    public long getCacheTime() {
        return this.cacheTimeMilli;
    }

    @Override
    public synchronized void close() {
        super.close();
        this.cache.clear();
    }
}

