/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.foxgenesis.property.IPropertyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ImmutableProperty<K, F, M extends IPropertyMapping> {
    @Nullable
    public M get(@NotNull F var1);

    @Nullable
    default public <U> U get(@NotNull F from, @NotNull Supplier<U> fallback, @NotNull Function<? super M, ? extends U> resolver) {
        Objects.requireNonNull(fallback);
        Objects.requireNonNull(resolver);
        M mapping = this.get(from);
        if (mapping != null) {
            return resolver.apply(mapping);
        }
        return fallback.get();
    }

    @Nullable
    default public <U> U get(@NotNull F from, @Nullable U fallback, @NotNull Function<? super M, ? extends U> resolver) {
        return this.get(from, (U)((Supplier<Object>)() -> fallback), resolver);
    }

    @Nullable
    default public <U> U get(@NotNull F from, @NotNull Function<? super M, U> resolver) {
        return (U)this.get(from, (U)((Supplier<Object>)() -> null), (Function<? super M, ? extends U>)resolver);
    }

    @NotNull
    public K getKey();

    public boolean isPresent(@NotNull F var1);

    public boolean isEditable();
}

