/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.util.function.Consumer;
import net.foxgenesis.property.IPropertyMapping;
import net.foxgenesis.property.ImmutableProperty;
import net.foxgenesis.property.UnmodifiablePropertyException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IProperty<K, L, M extends IPropertyMapping>
extends ImmutableProperty<K, L, M> {
    public boolean set(@NotNull L var1, @Nullable Object var2);

    default public boolean set(@NotNull L from, @Nullable Object value, boolean userEdited) {
        if (userEdited && !this.isEditable()) {
            throw new UnmodifiablePropertyException(this, this + " is not editable!");
        }
        return this.set(from, value);
    }

    default public void set(@NotNull L from, @Nullable Object value, boolean userEdited, @NotNull Consumer<Boolean> onSet, @Nullable Consumer<Throwable> errorHandler) {
        try {
            boolean wasSet = this.set(from, value, userEdited);
            onSet.accept(wasSet);
        }
        catch (Exception e) {
            if (errorHandler != null) {
                errorHandler.accept(e);
            }
            e.printStackTrace();
        }
    }
}

