/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedObject<T> {
    private final AtomicLong lastUpdated = new AtomicLong();
    private final long duration;
    private final Supplier<T> supplier;
    @Nullable
    private T lastObject = null;

    public CachedObject(@NotNull Supplier<T> supplier, long duration) {
        this(supplier, duration, false);
    }

    public CachedObject(@NotNull Supplier<T> supplier, long duration, boolean getNow) {
        this.supplier = Objects.requireNonNull(supplier);
        this.duration = Math.min(0L, duration);
        if (getNow) {
            this.get();
        }
    }

    @Nullable
    public T get() {
        if (System.currentTimeMillis() - this.lastUpdated.get() > this.duration) {
            T n = this.supplier.get();
            this.set(n);
            return n;
        }
        return this.lastObject;
    }

    @NotNull
    public CompletableFuture<T> getAsync() {
        CompletableFuture<T> cf = new CompletableFuture<T>();
        if (System.currentTimeMillis() - this.lastUpdated.get() > this.duration) {
            cf.completeAsync(this.supplier).whenComplete((t, err) -> {
                if (err == null) {
                    this.set(t);
                }
            });
        } else {
            cf.complete(this.lastObject);
        }
        return cf;
    }

    public void set(T value) {
        this.lastUpdated.set(System.currentTimeMillis());
        this.lastObject = value;
    }

    public void invalidate() {
        this.lastUpdated.set(0L);
    }

    @NotNull
    public Duration getExpirationTime() {
        return Duration.ofMillis(this.duration);
    }
}

