/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.sql;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Guild;
import net.foxgenesis.database.AbstractDatabase;
import net.foxgenesis.watame.Constants;
import net.foxgenesis.watame.property.GuildProperty;
import net.foxgenesis.watame.property.IGuildPropertyProvider;
import net.foxgenesis.watame.sql.GuildData;
import net.foxgenesis.watame.sql.IGuildData;
import net.foxgenesis.watame.sql.IGuildDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class WatameBotDatabase
extends AbstractDatabase
implements IGuildDataProvider,
IGuildPropertyProvider {
    static final Logger logger = LoggerFactory.getLogger((String)"Database");
    static final Logger sqlLogger = LoggerFactory.getLogger((String)"SQLInfo");
    static final Marker SQL_MARKER = MarkerFactory.getMarker((String)"SQL");
    static final Marker UPDATE_MARKER = MarkerFactory.getMarker((String)"SQL_UPDATE");
    static final Marker QUERY_MARKER = MarkerFactory.getMarker((String)"SQL_QUERY");
    private final ConcurrentHashMap<Long, GuildData> data = new ConcurrentHashMap();
    private final HashMap<String, GuildProperty> properties = new HashMap();

    public WatameBotDatabase() {
        super("WatameBot Database", Constants.DATABASE_OPERATIONS_FILE, Constants.DATABASE_SETUP_FILE);
    }

    @Deprecated(forRemoval=true)
    public void addGuild(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        logger.debug("Loading guild ({})[{}]", (Object)guild.getName(), (Object)guild.getIdLong());
        this.data.put(guild.getIdLong(), new GuildData(guild, this::pushJSONUpdate));
        this.retrieveData(guild);
        logger.trace("Guild loaded ({})[{}]", (Object)guild.getName(), (Object)guild.getIdLong());
    }

    @Deprecated(forRemoval=true)
    public void removeGuild(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        logger.debug("Removing guild ({})[{}]", (Object)guild.getName(), (Object)guild.getIdLong());
        try {
            this.data.remove(guild.getIdLong());
            logger.trace("Guild REMOVED ({})[{}]", (Object)guild.getName(), (Object)guild.getIdLong());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addGuild(final long id) {
        if (id == 0L) {
            throw new IllegalArgumentException("Invalid Guild ID");
        }
        logger.debug("Loading guild [{}]", (Object)id);
        this.data.computeIfAbsent(id, ID -> new GuildData(id, this::pushJSONUpdate));
        try {
            ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                @Override
                public boolean block() throws InterruptedException {
                    if (WatameBotDatabase.this.data.containsKey(id) && !WatameBotDatabase.this.data.get((Object)Long.valueOf((long)id)).setup) {
                        return WatameBotDatabase.this.retrieveData(id, 5);
                    }
                    return false;
                }

                @Override
                public boolean isReleasable() {
                    return WatameBotDatabase.this.data.containsKey(id) && WatameBotDatabase.this.data.get((Object)Long.valueOf((long)id)).setup;
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void removeGuild(long id) {
        if (id == 0L) {
            throw new IllegalArgumentException("Invalid Guild ID");
        }
        logger.debug("Removing guild [{}]", (Object)id);
        this.data.remove(id);
    }

    private boolean retrieveData(long guildID, int maxRetries) {
        return this.retrieveData(guildID, Math.max(0, maxRetries), 0);
    }

    private boolean retrieveData(long guildID, int maxRetry, int retry) {
        return retry > maxRetry ? false : (guildID == 0L ? false : this.mapStatement("guild_data_get_id", s -> {
            s.setLong(1, guildID);
            sqlLogger.trace(QUERY_MARKER, s.toString());
            try (ResultSet set = s.executeQuery();){
                long id;
                if (set.next() && (id = set.getLong("GuildID")) != 0L && this.data.containsKey(id)) {
                    this.data.get(id).setData(set);
                    Boolean bl = true;
                    return bl;
                }
                logger.warn("Guild [{}] is missing in database! Attempting to insert and retrieve...", (Object)guildID);
                Boolean bl = this.insertGuildInDatabase(guildID) && this.retrieveData(guildID, maxRetry, retry + 1);
                return bl;
            }
        }, e -> sqlLogger.error(QUERY_MARKER, "Error while reading guild", e)));
    }

    private boolean insertGuildInDatabase(long guild) {
        return guild == 0L ? false : this.mapStatement("guild_data_insert", st -> {
            st.setLong(1, guild);
            sqlLogger.trace(UPDATE_MARKER, st.toString());
            int result = st.executeUpdate();
            sqlLogger.debug("Insert Result: ", (Object)result);
            return result > 0;
        }, e -> sqlLogger.error(QUERY_MARKER, "Error while inserting new guild", e));
    }

    @Deprecated(forRemoval=true)
    private void insertGuildInDatabase(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        this.prepareStatement("guild_data_insert", st -> {
            long guildID = guild.getIdLong();
            st.setLong(1, guildID);
            sqlLogger.trace(UPDATE_MARKER, st.toString());
            System.out.println("update: " + st.executeUpdate());
        }, e -> sqlLogger.error(QUERY_MARKER, "Error while inserting new guild", e));
    }

    @Deprecated(forRemoval=true)
    private void retrieveData(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        this.prepareStatement("guild_data_get_id", s -> {
            s.setLong(1, guild.getIdLong());
            sqlLogger.trace(QUERY_MARKER, s.toString());
            try (ResultSet set = s.executeQuery();){
                long id;
                if (set.next() && (id = set.getLong("GuildID")) != 0L && this.data.containsKey(id)) {
                    this.data.get(id).setData(set);
                    return;
                }
                logger.warn("Guild ({})[{}] is missing in database! Attempting to insert and retrieve...", (Object)guild.getName(), (Object)guild.getIdLong());
                this.insertGuildInDatabase(guild);
                this.retrieveData(guild);
            }
        }, e -> sqlLogger.error(QUERY_MARKER, "Error while reading guild", e));
    }

    @Override
    @Nullable
    public IGuildData getDataForGuild(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Data not ready yet");
        }
        if (!this.data.containsKey(guild.getIdLong())) {
            throw new NullPointerException("Data has not been retrieved for guild!");
        }
        return this.data.get(guild.getIdLong());
    }

    private Integer pushJSONUpdate(@Nonnull String name, @Nullable Object data, long guild, boolean remove) {
        int result;
        Objects.requireNonNull(name);
        if (guild == 0L) {
            throw new IllegalArgumentException("Invalid guild ID");
        }
        if (remove) {
            result = this.mapStatement("guild_json_remove", removeStatement -> {
                removeStatement.setString(1, "$." + name);
                removeStatement.setLong(2, guild);
                sqlLogger.debug(UPDATE_MARKER, "PushUpdate -> " + removeStatement);
                return removeStatement.executeUpdate();
            }, e -> logger.error(UPDATE_MARKER, "Error while removing guild json data", e));
        } else {
            if (data == null) {
                throw new IllegalArgumentException("Data must not be null if 'remove' is 'false'!");
            }
            result = this.mapStatement("guild_json_update", updateStatement -> {
                updateStatement.setString(1, "$." + name);
                updateStatement.setString(2, data.toString());
                updateStatement.setLong(3, guild);
                sqlLogger.debug(UPDATE_MARKER, "PushUpdate -> " + updateStatement);
                return updateStatement.executeUpdate();
            }, e -> logger.error(UPDATE_MARKER, "Error while updating guild json data", e));
        }
        sqlLogger.debug(UPDATE_MARKER, "ExecuteUpdate <- " + result);
        return result;
    }

    public GuildProperty getProperty(@Nonnull String key) {
        return this.properties.computeIfAbsent(key, k -> new GuildProperty((String)k, this));
    }

    @Override
    public boolean isPropertyPresent(@Nonnull String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public void close() {
        this.data.clear();
        this.properties.clear();
    }

    @Override
    protected void onReady() {
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        return Set.copyOf(this.properties.keySet());
    }

    static {
        UPDATE_MARKER.add(SQL_MARKER);
        QUERY_MARKER.add(SQL_MARKER);
    }
}

