/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Guild;
import net.foxgenesis.config.fields.JSONObjectAdv;
import net.foxgenesis.util.function.QuadFunction;
import net.foxgenesis.watame.sql.IGuildData;
import net.foxgenesis.watame.sql.WatameBotDatabase;

public class GuildData
implements IGuildData {
    @Nonnull
    private final QuadFunction<String, Object, Long, Boolean, Integer> consumer;
    private final long id;
    private final ConcurrentHashMap<String, Object> temp = new ConcurrentHashMap();
    private JSONObjectAdv data;
    volatile boolean setup = false;

    @Deprecated(forRemoval=true)
    GuildData(@Nonnull Guild guild, @Nonnull QuadFunction<String, Object, Long, Boolean, Integer> consumer) {
        this(guild.getIdLong(), consumer);
    }

    GuildData(long id, @Nonnull QuadFunction<String, Object, Long, Boolean, Integer> consumer) {
        this.consumer = Objects.requireNonNull(consumer);
        this.id = id;
    }

    @Override
    public long getGuildID() {
        return this.id;
    }

    @Override
    @Nullable
    public JSONObjectAdv getConfig() {
        return this.data;
    }

    @Override
    public ConcurrentHashMap<String, Object> getTempData() {
        return this.temp;
    }

    void setData(@Nonnull ResultSet result) throws SQLException {
        String jsonString = result.getString("GuildProperties");
        WatameBotDatabase.sqlLogger.debug(WatameBotDatabase.SQL_MARKER, "SetData <- [{}] {}", (Object)this.id, (Object)jsonString);
        if (jsonString == null) {
            WatameBotDatabase.logger.warn("JSON STRING IS NULL FOR " + this.id, (Throwable)new NullPointerException("JSON STRING IS NULL FOR " + this.id));
            return;
        }
        this.data = new JSONObjectAdv(jsonString, (key, obj, remove) -> this.consumer.apply((String)key, obj, this.id, (Boolean)remove));
        this.setup = true;
    }

    public String toString() {
        return "GiuldData [setup=" + this.setup + ", id=" + this.id + ", temp=" + this.temp + ", config=" + this.data + "]";
    }
}

