/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.command.ConfigCommand;
import net.foxgenesis.watame.command.PingCommand;
import net.foxgenesis.watame.plugin.IEventStore;
import net.foxgenesis.watame.plugin.Plugin;
import org.apache.commons.configuration2.Configuration;

public class IntegratedCommands
extends Plugin {
    @Override
    protected void onPropertiesLoaded(Properties properties) {
    }

    @Override
    protected void onConfigurationLoaded(String identifier, Configuration properties) {
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init(IEventStore builder) {
        builder.registerListeners(this, new Object[]{new ConfigCommand(), new PingCommand()});
    }

    @Override
    public void postInit(WatameBot bot) {
    }

    @Override
    public void onReady(WatameBot bot) {
    }

    @Override
    public void close() {
    }

    @Override
    public Collection<CommandData> getCommands() {
        return List.of(Commands.slash((String)"ping", (String)"Ping the bot to test the connection"), IntegratedCommands.getOptionsCommand());
    }

    private static CommandData getOptionsCommand() {
        ArrayList<SubcommandGroupData> groups = new ArrayList<SubcommandGroupData>();
        groups.add(IntegratedCommands.getConfigSubCommands());
        return Commands.slash((String)"options", (String)"Change bot options").setGuildOnly(true).setDefaultPermissions(DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addSubcommandGroups(groups);
    }

    private static SubcommandGroupData getConfigSubCommands() {
        ArrayList<SubcommandData> commands = new ArrayList<SubcommandData>();
        for (OptionData option : IntegratedCommands.createAllOptions()) {
            commands.add(new SubcommandData("set-" + option.getName(), "Set a " + option.getName() + " value in the configuration").addOption(OptionType.STRING, "key", "Location of the variable", true, true).addOptions(new OptionData[]{option}));
        }
        commands.add(new SubcommandData("get", "Get a value from the configuration").addOption(OptionType.STRING, "key", "Location of the variable", true, true));
        commands.add(new SubcommandData("remove", "Remove a value from the configuration").addOption(OptionType.STRING, "key", "Location of the variable", true, true));
        commands.add(new SubcommandData("list", "List all configuration values"));
        return new SubcommandGroupData("configuration", "Get/Update plugin configuration").addSubcommands(commands);
    }

    private static List<OptionData> createAllOptions() {
        return Arrays.stream(OptionType.values()).filter(type -> type != OptionType.UNKNOWN && type != OptionType.SUB_COMMAND && type != OptionType.SUB_COMMAND_GROUP).map(type -> new OptionData(type, type.name().toLowerCase(), "Set the value as a " + type.name().toLowerCase()).setAutoComplete(false).setRequired(true)).toList();
    }
}

