/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.ChunkingFilter;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.foxgenesis.database.DatabaseManager;
import net.foxgenesis.database.IDatabaseManager;
import net.foxgenesis.database.providers.MySQLConnectionProvider;
import net.foxgenesis.executor.PrefixedForkJoinPoolFactory;
import net.foxgenesis.property.ImmutableProperty;
import net.foxgenesis.util.MethodTimer;
import net.foxgenesis.util.ResourceUtils;
import net.foxgenesis.watame.Constants;
import net.foxgenesis.watame.Context;
import net.foxgenesis.watame.ExitCode;
import net.foxgenesis.watame.Main;
import net.foxgenesis.watame.WatameBotSettings;
import net.foxgenesis.watame.plugin.Plugin;
import net.foxgenesis.watame.plugin.PluginHandler;
import net.foxgenesis.watame.property.GuildProperty;
import net.foxgenesis.watame.property.IGuildPropertyMapping;
import net.foxgenesis.watame.property.IGuildPropertyProvider;
import net.foxgenesis.watame.sql.IGuildData;
import net.foxgenesis.watame.sql.WatameBotDatabase;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class WatameBot {
    public static final Logger logger = LoggerFactory.getLogger(WatameBot.class);
    public static final WatameBot INSTANCE;
    private static final WatameBotSettings settings;
    private static final ImmutableConfiguration config;
    private JDABuilder builder;
    private JDA discord;
    private final DatabaseManager manager;
    private final WatameBotDatabase database;
    private final GuildProperty logChannel;
    private State state = State.CONSTRUCTING;
    private final PluginHandler<Plugin> pluginHandler;
    private final Context context;
    private final ConcurrentHashMap<String, String> mdcContext = new ConcurrentHashMap();

    private WatameBot(@Nonnull String token) {
        MDC.setContextMap(this.mdcContext);
        this.updateState(State.CONSTRUCTING);
        logger.debug("Creating WatameBot instance");
        logger.debug("Adding shutdown hook");
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown, "WatameBot Shutdown Thread"));
        this.manager = new DatabaseManager("WatameBot Database Manager");
        this.database = new WatameBotDatabase();
        this.logChannel = this.database.getProperty("log_channel");
        this.builder = this.createJDA(token, new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new PrefixedForkJoinPoolFactory("Event Worker"), null, true));
        this.context = new Context(this, this.builder, null);
        this.pluginHandler = new PluginHandler<Plugin>(this.context, this.getClass().getModule().getLayer(), Plugin.class);
    }

    void start() throws Exception {
        logger.info("Starting...");
        long start = System.nanoTime();
        this.pluginHandler.loadPlugins();
        this.updateState(State.PRE_INIT);
        this.preInit();
        this.updateState(State.INIT);
        this.init();
        this.updateState(State.POST_INIT);
        this.postInit();
        long end = System.nanoTime();
        this.updateState(State.RUNNING);
        logger.info("Startup completed in {} seconds", (Object)MethodTimer.formatToSeconds(end - start));
        this.ready();
    }

    private void shutdown() {
        this.updateState(State.SHUTDOWN);
        logger.info("Shutting down...");
        IOUtil.silentClose(this.pluginHandler);
        try {
            logger.info("Closing database connection");
            if (this.database != null) {
                this.database.close();
            }
        }
        catch (Exception e) {
            logger.error("Error while closing database connection!", (Throwable)e);
        }
        if (this.discord != null) {
            logger.info("Shutting down JDA...");
            this.discord.shutdown();
        }
        if (!ForkJoinPool.commonPool().awaitQuiescence(1L, TimeUnit.MINUTES)) {
            logger.warn("Timed out waiting for common pool shutdown. Continuing shutdown...");
        }
        logger.info("Exiting...");
    }

    private void preInit() throws Exception {
        CompletableFuture<Void> pluginPreInit = this.pluginHandler.preInit();
        try {
            logger.debug("Adding database to database manager");
            this.manager.register(this.pluginHandler.getPlugin("integrated"), this.database);
        }
        catch (IOException e) {
            ExitCode.DATABASE_SETUP_ERROR.programExit(e);
        }
        catch (IllegalArgumentException e) {
            ExitCode.DATABASE_INVALID_SETUP_FILE.programExit(e);
        }
        logger.debug("Waiting for plugin pre-initialization");
        pluginPreInit.join();
    }

    private void init() throws Exception {
        CompletableFuture<Void> pluginInit = this.pluginHandler.init();
        try {
            logger.info("Starting database pool");
            this.manager.start(new MySQLConnectionProvider(ResourceUtils.getProperties(Path.of("config", "database.properties"), Constants.DATABASE_SETTINGS_FILE)), null).join();
        }
        catch (IOException e) {
            ExitCode.DATABASE_SETUP_ERROR.programExit(e);
        }
        logger.debug("Waiting for plugin initialization");
        pluginInit.join();
    }

    private void postInit() throws Exception {
        logger.info("Connecting to discord");
        this.discord = this.buildJDA();
        this.context.onJDABuilder(this.discord);
        CompletableFuture<Void> pluginPostInit = this.pluginHandler.postInit(this);
        logger.info("Collecting commands...");
        this.pluginHandler.updateCommands(this.discord.updateCommands()).queue();
        logger.debug("Waiting for plugin post-initialization");
        pluginPostInit.join();
        if (this.discord.getStatus() != JDA.Status.CONNECTED) {
            try {
                logger.info("Waiting for JDA to be ready...");
                this.discord.awaitReady();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.info("Connected to discord!");
    }

    private void ready() {
        logger.debug("Setting presence to ready");
        this.discord.getPresence().setPresence(OnlineStatus.ONLINE, Activity.playing((String)config.getString("WatameBot.Status.online", "https://github.com/FoxGenesis/Watamebot")));
        this.pluginHandler.onReady(this);
    }

    private JDABuilder createJDA(String token, ExecutorService eventExecutor) {
        Objects.requireNonNull(token, "Login token must not be null");
        logger.debug("Creating JDA");
        JDABuilder builder = JDABuilder.create((String)token, (GatewayIntent)GatewayIntent.GUILD_MEMBERS, (GatewayIntent[])new GatewayIntent[]{GatewayIntent.GUILD_BANS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT}).disableCache(CacheFlag.ACTIVITY, new CacheFlag[]{CacheFlag.VOICE_STATE, CacheFlag.EMOJI, CacheFlag.STICKER, CacheFlag.CLIENT_STATUS, CacheFlag.ONLINE_STATUS}).setChunkingFilter(ChunkingFilter.ALL).setAutoReconnect(true).setActivity(Activity.playing((String)config.getString("WatameBot.Status.startup", "Initalizing..."))).setMemberCachePolicy(MemberCachePolicy.ALL).setStatus(OnlineStatus.DO_NOT_DISTURB);
        if (eventExecutor != null) {
            builder.setEventPool(eventExecutor, true);
        }
        builder.setContextEnabled(true);
        builder.setContextMap(this.mdcContext);
        return builder;
    }

    private JDA buildJDA() throws Exception {
        JDA discordTmp = null;
        boolean built = false;
        do {
            try {
                logger.info("Attempting to login to discord");
                discordTmp = this.builder.build();
                built = true;
            }
            catch (LoginException ex) {
                logger.warn("Failed to connect: [" + ex.getLocalizedMessage() + "]! Retrying in 5 seconds...", (Throwable)ex);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!built);
        if (discordTmp == null) {
            ExitCode.JDA_BUILD_FAIL.programExit("Failed to build JDA");
            return null;
        }
        ((JDAImpl)discordTmp).getGuildSetupController().setStatusListener((id, oldStatus, newStatus) -> {
            switch (newStatus) {
                case BUILDING: {
                    this.database.addGuild(id);
                    break;
                }
                case REMOVED: {
                    this.database.removeGuild(id);
                    break;
                }
            }
        });
        return discordTmp;
    }

    public boolean isConnectedToDiscord() {
        return this.discord != null && this.discord.getStatus() == JDA.Status.CONNECTED;
    }

    public IDatabaseManager getDatabaseManager() {
        return this.manager;
    }

    @Deprecated(forRemoval=true)
    public IGuildData getDataForGuild(Guild guild) {
        return this.database.getDataForGuild(guild);
    }

    public IGuildPropertyProvider getPropertyProvider() {
        return this.database;
    }

    public ImmutableProperty<String, Guild, IGuildPropertyMapping> getGuildLoggingChannel() {
        return this.logChannel;
    }

    public JDA getJDA() {
        return this.discord;
    }

    public State getState() {
        return this.state;
    }

    private void updateState(State state) {
        this.state = state;
        logger.trace("STATE = " + state);
        this.mdcContext.put("watame.status", state.name());
        MDC.put((String)"watame.status", (String)state.name());
    }

    static {
        settings = Main.getSettings();
        config = settings.getConfiguration();
        INSTANCE = new WatameBot(settings.getToken());
    }

    public static enum State {
        CONSTRUCTING,
        PRE_INIT,
        INIT,
        POST_INIT,
        RUNNING,
        SHUTDOWN;

        public final Marker marker = MarkerFactory.getMarker((String)this.name());
    }
}

