/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.util;

import java.util.Arrays;

public final class MethodTimer {
    public static double runNano(Runnable r) {
        long n = System.nanoTime();
        r.run();
        n = System.nanoTime() - n;
        return n;
    }

    public static double run(Runnable r) {
        return MethodTimer.runNano(r) / 1000000.0;
    }

    public static double run(Runnable r, int n) {
        double[] s = new double[n];
        for (int i = 0; i < n; ++i) {
            System.out.printf("===== Run #%s =====\n", i + 1);
            s[i] = MethodTimer.runNano(r);
            System.out.printf("==== %,.2fms ====\n", s[i] / 1000000.0);
        }
        return Arrays.stream(s).reduce((a, b) -> (a + b) / 2.0).orElseThrow() / 1000000.0;
    }

    public static String runFormatMS(Runnable r) {
        return MethodTimer.runFormatMS(r, 2);
    }

    public static String runFormatMS(Runnable r, int decimals) {
        return String.format("%." + decimals + "f ms", MethodTimer.run(r));
    }

    public static String runFormatMS(Runnable r, int n, int decimals) {
        return String.format("%." + decimals + "f ms", MethodTimer.run(r, n));
    }

    public static String runFormatSec(Runnable r) {
        return MethodTimer.runFormatSec(r, 2);
    }

    public static String runFormatSec(Runnable r, int decimals) {
        return String.format("%." + decimals + "f second(s)", MethodTimer.run(r) / 1000.0);
    }

    public static String runFormatSec(Runnable r, int n, int decimals) {
        return String.format("%." + decimals + "f second(s)", MethodTimer.run(r, n) / 1000.0);
    }

    public static String formatToMilli(long time) {
        return MethodTimer.formatToMilli(time, 2);
    }

    public static String formatToMilli(long time, int decimals) {
        return MethodTimer.format(time, decimals, 1000000.0);
    }

    public static String formatToSeconds(long time) {
        return MethodTimer.formatToSeconds(time, 2);
    }

    public static String formatToSeconds(long time, int decimals) {
        return MethodTimer.format(time, decimals, 1.0E9);
    }

    public static String format(long time, int decimals, double div) {
        return String.format("%,." + decimals + "f", (double)time / div);
    }
}

