/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property2.impl;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.foxgenesis.property2.Property;
import net.foxgenesis.property2.PropertyResolver;
import net.foxgenesis.property2.PropertyType;

public class PropertyImpl<L, R extends PropertyResolver<L>>
implements Property<L> {
    protected static final String DELIMETER = ",";
    @Nonnull
    protected final String key;
    @Nonnull
    protected final R resolver;
    @Nonnull
    protected PropertyType type = PropertyType.STRING;

    public PropertyImpl(@Nonnull String key, @Nonnull R resolver) {
        this.key = Objects.requireNonNull(key);
        this.resolver = (PropertyResolver)Objects.requireNonNull(resolver);
    }

    @Override
    @Nonnull
    public Optional<String> getString(L lookup) {
        return this.resolver.getString(lookup, this.key);
    }

    @Override
    @Nonnull
    public Optional<Boolean> getBoolean(L lookup) {
        return this.resolver.getBoolean(lookup, this.key);
    }

    @Override
    @Nonnull
    public Optional<Integer> getInt(L lookup) {
        return this.resolver.getInt(lookup, this.key);
    }

    @Override
    @Nonnull
    public Optional<Float> getFloat(L lookup) {
        return this.resolver.getFloat(lookup, this.key);
    }

    @Override
    @Nonnull
    public Optional<Double> getDouble(L lookup) {
        return this.resolver.getDouble(lookup, this.key);
    }

    @Override
    @Nonnull
    public Optional<Long> getLong(L lookup) {
        return this.resolver.getLong(lookup, this.key);
    }

    @Override
    @Nonnull
    public Optional<String[]> getStringArray(L lookup) {
        return this.resolver.getStringArray(lookup, this.key, DELIMETER);
    }

    @Override
    @Nonnull
    public Optional<Boolean[]> getBooleanArray(L lookup) {
        return this.resolver.getBooleanArray(lookup, this.key, DELIMETER);
    }

    @Override
    @Nonnull
    public Optional<Integer[]> getIntArray(L lookup) {
        return this.resolver.getIntArray(lookup, this.key, DELIMETER);
    }

    @Override
    @Nonnull
    public Optional<Float[]> getFloatArray(L lookup) {
        return this.resolver.getFloatArray(lookup, this.key, DELIMETER);
    }

    @Override
    @Nonnull
    public Optional<Double[]> getDoubleArray(L lookup) {
        return this.resolver.getDoubleArray(lookup, this.key, DELIMETER);
    }

    @Override
    @Nonnull
    public Optional<Long[]> getLongArray(L lookup) {
        return this.resolver.getLongArray(lookup, this.key, DELIMETER);
    }

    @Override
    public boolean putString(@Nonnull L lookup, @Nonnull String value) {
        return this.resolver.putString(lookup, this.key, value);
    }

    @Override
    public boolean putBoolean(@Nonnull L lookup, boolean value) {
        return this.resolver.putBoolean(lookup, this.key, value);
    }

    @Override
    public boolean putInt(@Nonnull L lookup, int value) {
        return this.resolver.putInt(lookup, this.key, value);
    }

    @Override
    public boolean putFloat(@Nonnull L lookup, float value) {
        return this.resolver.putFloat(lookup, this.key, value);
    }

    @Override
    public boolean putDouble(@Nonnull L lookup, double value) {
        return this.resolver.putDouble(lookup, this.key, value);
    }

    @Override
    public boolean putLong(@Nonnull L lookup, long value) {
        return this.resolver.putLong(lookup, this.key, value);
    }

    @Override
    public boolean putStringArray(@Nonnull L lookup, @Nonnull String[] arr) {
        return this.resolver.putStringArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putBooleanArray(@Nonnull L lookup, @Nonnull boolean[] arr) {
        return this.resolver.putBooleanArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putIntArray(@Nonnull L lookup, @Nonnull int[] arr) {
        return this.resolver.putIntArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putFloatArray(@Nonnull L lookup, @Nonnull float[] arr) {
        return this.resolver.putFloatArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putDoubleArray(@Nonnull L lookup, @Nonnull double[] arr) {
        return this.resolver.putDoubleArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean putLongArray(@Nonnull L lookup, @Nonnull long[] arr) {
        return this.resolver.putLongArray(lookup, this.key, DELIMETER, arr);
    }

    @Override
    public boolean remove(@Nonnull L lookup) {
        return this.resolver.remove(lookup, this.key);
    }

    @Override
    @Nonnull
    public PropertyType getType(@Nonnull L lookup) {
        return PropertyType.STRING;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String toString() {
        return "Property[key = " + this.key + ", type = " + this.type + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.resolver, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.resolver, other.resolver) && this.type == other.type;
    }
}

