/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property2.impl;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.foxgenesis.property2.PropertyType;
import net.foxgenesis.property2.async.AsyncProperty;
import net.foxgenesis.property2.async.AsyncPropertyResolver;
import net.foxgenesis.property2.impl.PropertyImpl;

public class AsyncPropertyImpl<L>
extends PropertyImpl<L, AsyncPropertyResolver<L>>
implements AsyncProperty<L> {
    public AsyncPropertyImpl(@Nonnull String key, @Nonnull AsyncPropertyResolver<L> resolver) {
        super(key, resolver);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<String>> getStringAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getStringAsync(lookup, this.key);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Boolean>> getBooleanAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getBooleanAsync(lookup, this.key);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Integer>> getIntAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getIntAsync(lookup, this.key);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Float>> getFloatAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getFloatAsync(lookup, this.key);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Double>> getDoubleAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getDoubleAsync(lookup, this.key);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Long>> getLongAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getLongAsync(lookup, this.key);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<String[]>> getStringArrayAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getStringArrayAsync(lookup, this.key, ",");
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Boolean[]>> getBooleanArrayAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getBooleanArrayAsync(lookup, this.key, ",");
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Integer[]>> getIntArrayAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getIntArrayAsync(lookup, this.key, ",");
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Float[]>> getFloatArrayAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getFloatArrayAsync(lookup, this.key, ",");
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Double[]>> getDoubleArrayAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getDoubleArrayAsync(lookup, this.key, ",");
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Long[]>> getLongArrayAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).getLongArrayAsync(lookup, this.key, ",");
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putStringAsync(@Nonnull L lookup, String value) {
        return ((AsyncPropertyResolver)this.resolver).putStringAsync(lookup, value, value);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putBooleanAsync(@Nonnull L lookup, boolean value) {
        return ((AsyncPropertyResolver)this.resolver).putBooleanAsync(lookup, this.key, value);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putIntAsync(@Nonnull L lookup, int value) {
        return ((AsyncPropertyResolver)this.resolver).putIntAsync(lookup, this.key, value);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putFloatAsync(@Nonnull L lookup, float value) {
        return ((AsyncPropertyResolver)this.resolver).putFloatAsync(lookup, this.key, value);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putDoubleAsync(@Nonnull L lookup, double value) {
        return ((AsyncPropertyResolver)this.resolver).putDoubleAsync(lookup, this.key, value);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putLongAsync(@Nonnull L lookup, long value) {
        return ((AsyncPropertyResolver)this.resolver).putLongAsync(lookup, this.key, value);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putStringArrayAsync(@Nonnull L lookup, @Nonnull String[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putStringArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putBooleanArrayAsync(@Nonnull L lookup, @Nonnull boolean[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putBooleanArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putIntArrayAsync(@Nonnull L lookup, @Nonnull int[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putIntArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putFloatArrayAsync(@Nonnull L lookup, @Nonnull float[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putFloatArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putDoubleArrayAsync(@Nonnull L lookup, @Nonnull double[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putDoubleArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putLongArrayAsync(@Nonnull L lookup, @Nonnull long[] arr) {
        return ((AsyncPropertyResolver)this.resolver).putLongArrayAsync(lookup, this.key, ",", arr);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> removeAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).removeAsync(lookup, this.key);
    }

    @Override
    @Nonnull
    public CompletableFuture<PropertyType> getTypeAsync(@Nonnull L lookup) {
        return ((AsyncPropertyResolver)this.resolver).typeOfAsync(lookup, this.key);
    }
}

