/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.database;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.foxgenesis.database.AbstractDatabase;
import net.foxgenesis.property2.PropertyType;
import net.foxgenesis.property2.async.AsyncPropertyResolver;
import net.foxgenesis.util.resource.FormattedModuleResource;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ConfigurationDatabase<L>
extends AbstractDatabase
implements AsyncPropertyResolver<L> {
    private static final ExecutorService COMMON_POOL = ForkJoinPool.commonPool();
    private final ExecutorService defaultExecutor;
    private final String database;
    private final String table;

    public ConfigurationDatabase(@Nonnull String name, @Nonnull String database, @Nonnull String table, @Nullable ExecutorService service) {
        super(name, new FormattedModuleResource("watamebot", "/META-INF/configDatabase/statements.kvp", Map.of("database", database, "table", table)), new FormattedModuleResource("watamebot", "/META-INF/configDatabase/setup.sql", Map.of("database", database, "table", table)));
        this.database = Objects.requireNonNull(database);
        this.table = Objects.requireNonNull(table);
        this.defaultExecutor = Objects.requireNonNullElse(service, COMMON_POOL);
    }

    public ConfigurationDatabase(@Nonnull String name, @Nonnull String database, @Nonnull String table) {
        this(name, database, table, null);
    }

    @Nonnull
    protected CompletableFuture<Boolean> removeInternalAsync(@Nonnull L lookup, @Nonnull String key, @Nullable ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> this.removeInternal(lookup, key), this.screenExecutor(service));
    }

    @Nonnull
    protected CompletableFuture<Boolean> putInternalAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String value, @Nullable ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> this.putInternal(lookup, key, value), this.screenExecutor(service));
    }

    @Nonnull
    private CompletableFuture<Boolean> putInternalAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull Supplier<String> value, @Nullable ExecutorService service) {
        return CompletableFuture.supplyAsync(value, this.screenExecutor(service)).thenCompose(v -> this.putInternalAsync(lookup, key, (String)v, service));
    }

    @Nonnull
    protected CompletableFuture<Optional<String>> getInternalAsync(@Nonnull L lookup, @Nonnull String key, @Nullable ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> this.getInternal(lookup, key), this.screenExecutor(service));
    }

    @Nonnull
    protected <T> CompletableFuture<Boolean> putArrayInternalAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull T[] arr, @Nullable ExecutorService service) {
        if (arr.length == 0) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Array must not be empty!"));
        }
        return this.putInternalAsync(lookup, key, () -> Arrays.stream(arr).map(Object::toString).reduce((a, b) -> a.toString() + delimeter + b.toString()).get(), service);
    }

    @Nonnull
    protected <T> CompletableFuture<Optional<T[]>> getArrayInternalAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex, @Nonnull Function<String, T> map, @Nonnull IntFunction<T[]> arr, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApplyAsync(o -> o.map(str -> Arrays.stream(str.split(regex)).map(map).toArray(arr)), (Executor)this.screenExecutor(service));
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<String>> getStringAsync(@Nonnull L lookup, @Nonnull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Boolean>> getBooleanAsync(@Nonnull L lookup, @Nonnull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Boolean::parseBoolean));
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Integer>> getIntAsync(@Nonnull L lookup, @Nonnull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Integer::parseInt));
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Float>> getFloatAsync(@Nonnull L lookup, @Nonnull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Float::parseFloat));
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Double>> getDoubleAsync(@Nonnull L lookup, @Nonnull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Double::parseDouble));
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Long>> getLongAsync(@Nonnull L lookup, @Nonnull String key, @Nullable ExecutorService service) {
        return this.getInternalAsync(lookup, key, service).thenApply(o -> o.map(Long::parseLong));
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<String[]>> getStringArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Function.identity(), String[]::new, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Boolean[]>> getBooleanArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Boolean::parseBoolean, Boolean[]::new, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Integer[]>> getIntArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Integer::parseInt, Integer[]::new, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Float[]>> getFloatArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Float::parseFloat, Float[]::new, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Double[]>> getDoubleArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Double::parseDouble, Double[]::new, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Optional<Long[]>> getLongArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex, @Nullable ExecutorService service) {
        return this.getArrayInternalAsync(lookup, key, regex, Long::parseLong, Long[]::new, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putStringAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, value, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putBooleanAsync(@Nonnull L lookup, @Nonnull String key, boolean value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putIntAsync(@Nonnull L lookup, @Nonnull String key, int value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putFloatAsync(@Nonnull L lookup, @Nonnull String key, float value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putDoubleAsync(@Nonnull L lookup, @Nonnull String key, double value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putLongAsync(@Nonnull L lookup, @Nonnull String key, long value, @Nullable ExecutorService service) {
        return this.putInternalAsync(lookup, key, "" + value, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putStringArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull String[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, arr, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putBooleanArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull boolean[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((boolean[])arr), service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putIntArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull int[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((int[])arr), service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putFloatArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull float[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((float[])arr), service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putDoubleArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull double[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((double[])arr), service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> putLongArrayAsync(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull long[] arr, @Nullable ExecutorService service) {
        return this.putArrayInternalAsync(lookup, key, delimeter, ArrayUtils.toObject((long[])arr), service);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> removeAsync(@Nonnull L lookup, @Nonnull String key, @Nullable ExecutorService service) {
        return this.removeInternalAsync(lookup, key, service);
    }

    @Override
    @Nonnull
    public CompletableFuture<PropertyType> typeOfAsync(L lookup, String key, ExecutorService service) {
        return CompletableFuture.completedFuture(PropertyType.STRING);
    }

    protected abstract boolean removeInternal(@Nonnull L var1, @Nonnull String var2);

    protected abstract boolean putInternal(@Nonnull L var1, @Nonnull String var2, @Nonnull String var3);

    @Nonnull
    protected abstract Optional<String> getInternal(@Nonnull L var1, @Nonnull String var2);

    protected <T> boolean putArrayInternal(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull T[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array must not be empty!");
        }
        return this.putInternal(lookup, key, Arrays.stream(arr).map(Object::toString).reduce((a, b) -> a.toString() + delimeter + b.toString()).get());
    }

    @Nonnull
    protected <T> Optional<T[]> getArrayInternal(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex, @Nonnull Function<String, T> map, @Nonnull IntFunction<T[]> arr) {
        return this.getInternal(lookup, key).map(str -> Arrays.stream(str.split(regex)).map(map).toArray(arr));
    }

    @Override
    @Nonnull
    public Optional<String> getString(L lookup, String key) {
        return this.getInternal(lookup, key);
    }

    @Override
    @Nonnull
    public Optional<Boolean> getBoolean(L lookup, String key) {
        return this.getInternal(lookup, key).map(Boolean::parseBoolean);
    }

    @Override
    @Nonnull
    public Optional<Integer> getInt(@Nonnull L lookup, @Nonnull String key) {
        return this.getInternal(lookup, key).map(Integer::parseInt);
    }

    @Override
    @Nonnull
    public Optional<Float> getFloat(@Nonnull L lookup, @Nonnull String key) {
        return this.getInternal(lookup, key).map(Float::parseFloat);
    }

    @Override
    @Nonnull
    public Optional<Double> getDouble(@Nonnull L lookup, @Nonnull String key) {
        return this.getInternal(lookup, key).map(Double::parseDouble);
    }

    @Override
    @Nonnull
    public Optional<Long> getLong(@Nonnull L lookup, @Nonnull String key) {
        return this.getInternal(lookup, key).map(Long::parseLong);
    }

    @Override
    @Nonnull
    public Optional<String[]> getStringArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex) {
        return this.getArrayInternal(lookup, key, regex, Function.identity(), String[]::new);
    }

    @Override
    @Nonnull
    public Optional<Boolean[]> getBooleanArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex) {
        return this.getArrayInternal(lookup, key, regex, Boolean::parseBoolean, Boolean[]::new);
    }

    @Override
    @Nonnull
    public Optional<Integer[]> getIntArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex) {
        return this.getArrayInternal(lookup, key, regex, Integer::parseInt, Integer[]::new);
    }

    @Override
    @Nonnull
    public Optional<Float[]> getFloatArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex) {
        return this.getArrayInternal(lookup, key, regex, Float::parseFloat, Float[]::new);
    }

    @Override
    @Nonnull
    public Optional<Double[]> getDoubleArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex) {
        return this.getArrayInternal(lookup, key, regex, Double::parseDouble, Double[]::new);
    }

    @Override
    @Nonnull
    public Optional<Long[]> getLongArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String regex) {
        return this.getArrayInternal(lookup, key, regex, Long::parseLong, Long[]::new);
    }

    @Override
    public boolean putString(@Nonnull L lookup, @Nonnull String key, @Nonnull String value) {
        return this.putInternal(lookup, key, value);
    }

    @Override
    public boolean putBoolean(@Nonnull L lookup, @Nonnull String key, boolean value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putInt(@Nonnull L lookup, @Nonnull String key, int value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putFloat(@Nonnull L lookup, @Nonnull String key, float value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putDouble(@Nonnull L lookup, @Nonnull String key, double value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putLong(@Nonnull L lookup, @Nonnull String key, long value) {
        return this.putInternal(lookup, key, "" + value);
    }

    @Override
    public boolean putStringArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull String[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, arr);
    }

    @Override
    public boolean putBooleanArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull boolean[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((boolean[])arr));
    }

    @Override
    public boolean putIntArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull int[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((int[])arr));
    }

    @Override
    public boolean putFloatArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull float[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((float[])arr));
    }

    @Override
    public boolean putDoubleArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull double[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((double[])arr));
    }

    @Override
    public boolean putLongArray(@Nonnull L lookup, @Nonnull String key, @Nonnull String delimeter, @Nonnull long[] arr) {
        return this.putArrayInternal(lookup, key, delimeter, ArrayUtils.toObject((long[])arr));
    }

    @Override
    public boolean remove(@Nonnull L lookup, @Nonnull String key) {
        return this.removeInternal(lookup, key);
    }

    @Override
    @Nonnull
    public PropertyType typeOf(L lookup, String key) {
        return PropertyType.STRING;
    }

    @Nonnull
    public String getDatabase() {
        return this.database;
    }

    @Nonnull
    public String getTable() {
        return this.table;
    }

    @Nonnull
    private ExecutorService screenExecutor(@Nullable ExecutorService service) {
        return service != null ? service : this.defaultExecutor;
    }
}

