/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.foxgenesis.property.IPropertyMapping;

public interface ImmutableProperty<K, F, M extends IPropertyMapping> {
    @CheckForNull
    public M get(@Nonnull F var1);

    default public <U> U get(@Nonnull F from, @Nonnull Supplier<U> fallback, @Nonnull Function<? super M, ? extends U> resolver) {
        Objects.requireNonNull(fallback);
        Objects.requireNonNull(resolver);
        M mapping = this.get(from);
        if (mapping != null) {
            return resolver.apply(mapping);
        }
        return fallback.get();
    }

    default public <U> U get(@Nonnull F from, @Nullable U fallback, @Nonnull Function<? super M, ? extends U> resolver) {
        return this.get(from, (U)((Supplier<Object>)() -> fallback), resolver);
    }

    default public <U> U get(@Nonnull F from, @Nonnull Function<? super M, U> resolver) {
        return (U)this.get(from, (U)((Supplier<Object>)() -> null), (Function<? super M, ? extends U>)resolver);
    }

    @Nonnull
    public K getKey();

    public boolean isPresent(@Nonnull F var1);

    public boolean isEditable();
}

