/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.foxgenesis.property.IPropertyMapping;
import net.foxgenesis.property.ImmutableProperty;
import net.foxgenesis.property.UnmodifiablePropertyException;

public interface IProperty<K, L, M extends IPropertyMapping>
extends ImmutableProperty<K, L, M> {
    public boolean set(@Nonnull L var1, @Nullable Object var2);

    default public boolean set(@Nonnull L from, @Nullable Object value, boolean userEdited) {
        if (userEdited && !this.isEditable()) {
            throw new UnmodifiablePropertyException(this, this + " is not editable!");
        }
        return this.set(from, value);
    }

    default public void set(@Nonnull L from, @Nullable Object value, boolean userEdited, @Nonnull Consumer<Boolean> onSet, @Nullable Consumer<Throwable> errorHandler) {
        try {
            boolean wasSet = this.set(from, value, userEdited);
            onSet.accept(wasSet);
        }
        catch (Exception e) {
            if (errorHandler != null) {
                errorHandler.accept(e);
            }
            e.printStackTrace();
        }
    }
}

