/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.database.providers;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import net.foxgenesis.database.AConnectionProvider;

public class MySQLConnectionProvider
extends AConnectionProvider {
    private final HikariDataSource source;

    public MySQLConnectionProvider(Properties properties) throws ConnectException {
        super(properties, "MySQL Connection Provider");
        properties.putIfAbsent("dataSource.cachePrepStmts", (Object)true);
        properties.putIfAbsent("dataSource.prepStmtCacheSize", (Object)250);
        properties.putIfAbsent("dataSource.prepStmtCacheSqlLimit", (Object)2048);
        properties.putIfAbsent("dataSource.useServerPrepStmts", (Object)true);
        properties.putIfAbsent("dataSource.useLocalSessionState", (Object)true);
        properties.putIfAbsent("dataSource.rewriteBatchedStatements", (Object)true);
        properties.putIfAbsent("dataSource.cacheResultSetMetadata", (Object)true);
        properties.putIfAbsent("dataSource.cacheServerConfiguration", (Object)true);
        properties.putIfAbsent("dataSource.elideSetAutoCommits", (Object)false);
        properties.putIfAbsent("dataSource.maintainTimeStats", (Object)true);
        try {
            this.source = new HikariDataSource(new HikariConfig(properties));
        }
        catch (Exception e) {
            throw new ConnectException("Failed to connect to database");
        }
    }

    @Override
    protected Connection openConnection() throws SQLException {
        return this.source.getConnection();
    }
}

