/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Channel;
import net.dv8tion.jda.api.entities.Guild;
import net.foxgenesis.config.fields.JSONObjectAdv;
import net.foxgenesis.util.function.QuadFunction;
import net.foxgenesis.watame.sql.IGuildData;
import net.foxgenesis.watame.sql.WatameBotDatabase;

public class GuildData
implements IGuildData {
    @Nonnull
    private final QuadFunction<String, Object, Guild, Boolean, Integer> consumer;
    @Nonnull
    private final Guild guild;
    private final ConcurrentHashMap<String, Object> temp = new ConcurrentHashMap();
    private JSONObjectAdv data;
    private boolean setup = false;

    GuildData(@Nonnull Guild guild, @Nonnull QuadFunction<String, Object, Guild, Boolean, Integer> consumer) {
        Objects.nonNull(consumer);
        this.consumer = consumer;
        Objects.nonNull(guild);
        this.guild = guild;
    }

    @Override
    public Guild getGuild() {
        this.checkSetup();
        return this.guild;
    }

    @Override
    @Nullable
    public JSONObjectAdv getConfig() {
        this.checkSetup();
        return this.data;
    }

    @Override
    @CheckForNull
    public Channel getLogChannel() {
        this.checkSetup();
        return this.guild.getTextChannelById(this.data.optLong("guild.log_channel"));
    }

    @Override
    public ConcurrentHashMap<String, Object> getTempData() {
        this.checkSetup();
        return this.temp;
    }

    void setData(@Nonnull ResultSet result) throws SQLException {
        Objects.requireNonNull(result);
        String jsonString = result.getString("GuildProperties");
        WatameBotDatabase.sqlLogger.debug(WatameBotDatabase.SQL_MARKER, "SetData <- [{}] {}", (Object)this.guild.getName(), (Object)jsonString);
        if (jsonString == null) {
            WatameBotDatabase.logger.warn("JSON STRING IS NULL FOR " + this.guild.getIdLong(), (Throwable)new NullPointerException("JSON STRING IS NULL FOR " + this.guild.getIdLong()));
            return;
        }
        this.data = new JSONObjectAdv(jsonString, (key, obj, remove) -> this.consumer.apply((String)key, obj, this.guild, (Boolean)remove));
        this.setup = true;
    }

    private void checkSetup() {
        if (this.setup) {
            return;
        }
        WatameBotDatabase.logger.debug("Waiting for guild data in {}", (Object)this.guild.getName());
        long start = System.currentTimeMillis();
        while (!this.setup && System.currentTimeMillis() - start < 5000L) {
            Thread.onSpinWait();
        }
        if (!this.setup) {
            throw new UnsupportedOperationException("GuildData has not been setup yet!");
        }
    }

    public String toString() {
        return "GiuldData [setup=" + this.setup + ", guild=" + this.guild + ", temp=" + this.temp + ", config=" + this.data + "]";
    }
}

